/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ProficiencyMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;

public class PlayerProficiencyData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerProficiency";
    private final Map<UUID, Integer> playerProficiency = new HashMap<UUID, Integer>();

    private PlayerProficiencyData() {
    }

    private PlayerProficiencyData(CompoundTag tag) {
        this.load(tag);
    }

    public Integer getAbsoluteProficiency(Player player) {
        return this.getAbsoluteProficiency(player.m_142081_());
    }

    public Integer getAbsoluteProficiency(UUID playerId) {
        return this.playerProficiency.getOrDefault(playerId, 0);
    }

    public void setAbsoluteProficiency(UUID playerId, int value) {
        this.playerProficiency.put(playerId, value);
        this.m_77762_();
    }

    public void addAbsoluteProficiency(UUID playerId, int value) {
        this.setAbsoluteProficiency(playerId, this.getAbsoluteProficiency(playerId) + value);
    }

    public void sendProficiencyInformation(ServerPlayer player) {
        UUID playerId = player.m_142081_();
        int absProficiency = this.getAbsoluteProficiency(playerId);
        ModNetwork.CHANNEL.sendTo((Object)new ProficiencyMessage(absProficiency), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    protected void load(CompoundTag tag) {
        this.playerProficiency.clear();
        for (String playerIdStr : tag.m_128431_()) {
            UUID playerId = UUID.fromString(playerIdStr);
            int proficiency = tag.m_128451_(playerIdStr);
            this.playerProficiency.put(playerId, proficiency);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.playerProficiency.forEach((playerId, proficiency) -> tag.m_128405_(playerId.toString(), proficiency.intValue()));
        return tag;
    }

    public static PlayerProficiencyData get(ServerLevel world) {
        return PlayerProficiencyData.get(world.m_142572_());
    }

    public static PlayerProficiencyData get(MinecraftServer server) {
        return (PlayerProficiencyData)server.m_129783_().m_8895_().m_164861_(PlayerProficiencyData::new, PlayerProficiencyData::new, DATA_NAME);
    }
}

