/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.altar.RequiredItems;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.stats.CrystalStat;
import iskallia.vault.world.stats.RaffleStat;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerStatsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerStats";
    protected VMapNBT<UUID, Stats> playerStats = VMapNBT.ofUUID(Stats::new);

    public Stats get(Player player) {
        return this.get(player.m_142081_());
    }

    public Stats get(UUID playerId) {
        return (Stats)this.playerStats.computeIfAbsent(playerId, uuid -> new Stats());
    }

    public void onCrystalCrafted(UUID playerId, List<RequiredItems> recipe) {
        this.get((UUID)playerId).crystals.add(new CrystalStat(recipe));
        this.m_77762_();
    }

    public void onGreedCrystalCrafted(UUID playerId, List<RequiredItems> recipe) {
        this.get((UUID)playerId).crystals.add(new CrystalStat(recipe).setGreed(true));
        this.m_77762_();
    }

    public void clearCrystals(UUID playerId) {
        this.get((UUID)playerId).crystals.clear();
        this.m_77762_();
    }

    public void onRaffleCompleted(UUID playerId, WeightedList<String> contributors, String winner) {
        this.get((UUID)playerId).raffles.add(new RaffleStat(contributors, winner));
        this.m_77762_();
    }

    private static PlayerStatsData create(CompoundTag tag) {
        PlayerStatsData data = new PlayerStatsData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.playerStats.deserializeNBT(nbt.m_128437_("Stats", 10));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("Stats", (Tag)this.playerStats.serializeNBT());
        return nbt;
    }

    public static PlayerStatsData get(MinecraftServer server) {
        return (PlayerStatsData)server.m_129783_().m_8895_().m_164861_(PlayerStatsData::create, PlayerStatsData::new, DATA_NAME);
    }

    public static PlayerStatsData get() {
        return PlayerStatsData.get(ServerLifecycleHooks.getCurrentServer());
    }

    public static class Stats
    implements INBTSerializable<CompoundTag> {
        protected VListNBT<CrystalStat, CompoundTag> crystals = VListNBT.of(() -> new CrystalStat());
        protected VListNBT<RaffleStat, CompoundTag> raffles = VListNBT.of(RaffleStat::new);

        public List<CrystalStat> getCrystals() {
            return Collections.unmodifiableList(this.crystals);
        }

        public List<RaffleStat> getRaffles() {
            return Collections.unmodifiableList(this.raffles);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Crystals", (Tag)this.crystals.serializeNBT());
            nbt.m_128365_("Raffles", (Tag)this.raffles.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.crystals.deserializeNBT(nbt.m_128437_("Crystals", 10));
            this.raffles.deserializeNBT(nbt.m_128437_("Raffles", 10));
        }
    }
}

