/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.WeekKey;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerVaultStatsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerVaultLevels";
    private final Map<UUID, PlayerVaultStats> playerMap = new HashMap<UUID, PlayerVaultStats>();
    private final Map<WeekKey, List<PlayerRecordEntry>> weeklyVaultRecords = new HashMap<WeekKey, List<PlayerRecordEntry>>();

    public PlayerVaultStats getVaultStats(Player player) {
        return this.getVaultStats(player.m_142081_());
    }

    public PlayerVaultStats getVaultStats(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, PlayerVaultStats::new);
    }

    public PlayerVaultStatsData setVaultLevel(ServerPlayer player, int level) {
        this.getVaultStats((Player)player).setVaultLevel(player.m_20194_(), level);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addVaultExp(ServerPlayer player, int exp) {
        this.getVaultStats((Player)player).addVaultExp(player.m_20194_(), exp);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendSkillPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendSkillPoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendPrestigePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendPrestigePoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendKnowledgePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendKnowledgePoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendArchetypePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendArchetypePoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendRegretPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendRegretPoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addSkillPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addSkillPoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addPrestigePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addPrestigePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetSkillPoints(ServerPlayer player) {
        this.getVaultStats((Player)player).setSkillPoints(0).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetPrestigePoints(ServerPlayer player) {
        this.getVaultStats((Player)player).setPrestigePoints(0).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addExpertisePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addExpertisePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData refundSkillPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).refundSkillPoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData refundPrestigePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).refundPrestigePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData refundKnowledgePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).refundKnowledgePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData refundArchetypePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).refundArchetypePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addKnowledgePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addKnowledgePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addArchetypePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addArchetypePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetLevelAbilitiesAndExpertise(ServerPlayer player) {
        this.resetLevel(player);
        this.resetSkills(player);
        this.resetExpertises(player);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetSkills(ServerPlayer player) {
        return this.resetSkills(player, false);
    }

    public PlayerVaultStatsData resetSkills(ServerPlayer player, boolean resetPoints) {
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(player.m_183503_());
        PlayerTalentsData talentsData = PlayerTalentsData.get(player.m_183503_());
        PlayerAbilitiesData abilitiesData = PlayerAbilitiesData.get(player.m_183503_());
        TalentTree talentTree = talentsData.getTalents((Player)player);
        AbilityTree abilityTree = abilitiesData.getAbilities((Player)player);
        PlayerVaultStats stats = statsData.getVaultStats((Player)player);
        SkillContext context = SkillContext.empty();
        talentTree.iterate(Skill.class, skill -> {
            if (skill instanceof GroupedSkill) {
                return;
            }
            while (skill instanceof LearnableSkill) {
                LearnableSkill learnable = (LearnableSkill)skill;
                if (!skill.isUnlocked()) break;
                learnable.regret(context);
            }
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                specialized.resetSpecialization(context);
            }
        });
        abilityTree.iterate(Skill.class, skill -> {
            if (skill instanceof GroupedSkill) {
                return;
            }
            while (skill instanceof LearnableSkill) {
                LearnableSkill learnable = (LearnableSkill)skill;
                if (!skill.isUnlocked()) break;
                learnable.regret(context);
            }
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                specialized.resetSpecialization(context);
            }
        });
        if (resetPoints) {
            stats.addSkillPoints(context.getLearnPoints());
        }
        stats.sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetKnowledge(ServerPlayer player) {
        this.getVaultStats((Player)player).resetKnowledge(player.m_183503_().m_142572_()).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public PlayerVaultStatsData resetExpertises(ServerPlayer player) {
        this.getVaultStats((Player)player).resetExpertise(player.m_183503_().m_142572_()).sync(player.m_183503_().m_142572_());
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(player.m_183503_());
        PlayerExpertisesData expertisesData = PlayerExpertisesData.get(player.m_183503_());
        ExpertiseTree expertisesTree = expertisesData.getExpertises((Player)player);
        PlayerVaultStats stats = statsData.getVaultStats((Player)player);
        for (Skill skill : expertisesTree.getAll(LearnableSkill.class, Skill::isUnlocked)) {
            void var7_7;
            while (var7_7.isUnlocked()) {
                SkillContext context = SkillContext.of(player);
                Skill skill2 = var7_7.getParent();
                if (skill2 instanceof GroupedSkill) {
                    GroupedSkill grouped = (GroupedSkill)skill2;
                    grouped.select(var7_7.getId());
                    GroupedSkill groupedSkill = grouped;
                }
                if (!(var7_7 instanceof LearnableSkill)) continue;
                LearnableSkill learnable = (LearnableSkill)var7_7;
                learnable.regret(context);
                expertisesTree.sync(context);
            }
        }
        stats.setExpertisePoints(0);
        stats.sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetLevel(ServerPlayer player) {
        this.getVaultStats((Player)player).resetLevel(player.m_183503_().m_142572_()).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetAndReturnSkillPoints(ServerPlayer player) {
        this.getVaultStats((Player)player).resetAndReturnSkillPoints().sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public void resetAndReturnAllPlayerExpertisePoints(ServerLevel level) {
        this.playerMap.forEach((uuid, playerVaultStatsData) -> this.getVaultStats((UUID)uuid).resetAndReturnExpertisePoints().sync(level.m_142572_()));
        this.m_77762_();
    }

    public PlayerVaultStatsData resetAndReturnExpertisePoints(ServerPlayer player) {
        this.getVaultStats((Player)player).resetAndReturnExpertisePoints().sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetAndReturnKnowledgePoints(ServerPlayer player) {
        this.getVaultStats((Player)player).resetAndReturnKnowledgePoints().sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData resetAndReturnArchetypePoints(ServerPlayer player) {
        this.getVaultStats((Player)player).resetAndReturnArchetypePoints().sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData reset(ServerPlayer player) {
        this.getVaultStats((Player)player).reset(player.m_20194_());
        this.m_77762_();
        return this;
    }

    @Nonnull
    public PlayerRecordEntry getFastestVaultTime() {
        return this.getFastestVaultTime(WeekKey.current());
    }

    @Nonnull
    public PlayerRecordEntry getFastestVaultTime(WeekKey week) {
        return this.weeklyVaultRecords.computeIfAbsent(week, key -> new ArrayList()).stream().min(Comparator.comparing(PlayerRecordEntry::getTickCount)).orElse(PlayerRecordEntry.DEFAULT);
    }

    public void updateFastestVaultTime(Player player, int timeTicks) {
        this.updateFastestVaultTime(new PlayerRecordEntry(player.m_142081_(), player.m_7755_().getString(), timeTicks));
    }

    private void updateFastestVaultTime(PlayerRecordEntry entry) {
        this.weeklyVaultRecords.computeIfAbsent(WeekKey.current(), key -> new ArrayList()).add(entry);
        this.m_77762_();
    }

    public boolean m_77764_() {
        return true;
    }

    public static PlayerVaultStatsData getServer() {
        return PlayerVaultStatsData.get(ServerLifecycleHooks.getCurrentServer());
    }

    public static PlayerVaultStatsData get(ServerLevel world) {
        return PlayerVaultStatsData.get(world.m_142572_());
    }

    public static PlayerVaultStatsData get(MinecraftServer srv) {
        return (PlayerVaultStatsData)srv.m_129783_().m_8895_().m_164861_(PlayerVaultStatsData::create, PlayerVaultStatsData::new, DATA_NAME);
    }

    private static PlayerVaultStatsData create(CompoundTag tag) {
        PlayerVaultStatsData data = new PlayerVaultStatsData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        int i;
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag statEntries = nbt.m_128437_("StatEntries", 10);
        ListTag weeklyRecords = nbt.m_128437_("WeeklyRecords", 10);
        if (playerList.size() != statEntries.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getVaultStats(playerUUID).deserializeNBT(statEntries.m_128728_(i));
        }
        for (i = 0; i < weeklyRecords.size(); ++i) {
            CompoundTag tag = weeklyRecords.m_128728_(i);
            WeekKey key = WeekKey.deserialize(tag.m_128469_("weekKey"));
            ArrayList<PlayerRecordEntry> recordEntries = new ArrayList<PlayerRecordEntry>();
            ListTag entries = tag.m_128437_("entries", 10);
            for (int j = 0; j < entries.size(); ++j) {
                recordEntries.add(PlayerRecordEntry.deserialize(entries.m_128728_(j)));
            }
            this.weeklyVaultRecords.put(key, recordEntries);
        }
        if (nbt.m_128425_("RecordEntries", 9)) {
            ListTag recordList = nbt.m_128437_("RecordEntries", 10);
            for (int i2 = 0; i2 < recordList.size(); ++i2) {
                this.updateFastestVaultTime(PlayerRecordEntry.deserialize(recordList.m_128728_(i2)));
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag statsList = new ListTag();
        ListTag recordWeekList = new ListTag();
        this.playerMap.forEach((uuid, stats) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            statsList.add((Object)stats.serializeNBT());
        });
        nbt.m_128365_("PlayerEntries", (Tag)playerList);
        nbt.m_128365_("StatEntries", (Tag)statsList);
        this.weeklyVaultRecords.forEach((weekKey, entries) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("weekKey", (Tag)weekKey.serialize());
            ListTag recordEntries = new ListTag();
            entries.forEach(entry -> recordEntries.add((Object)entry.serialize()));
            tag.m_128365_("entries", (Tag)recordEntries);
            recordWeekList.add((Object)tag);
        });
        nbt.m_128365_("WeeklyRecords", (Tag)recordWeekList);
        return nbt;
    }

    public void resetSkillAndPrestigePoints(ServerPlayer player) {
        this.resetSkillPoints(player);
        this.resetPrestigePoints(player);
        this.m_77762_();
    }

    public static class PlayerRecordEntry {
        private static final PlayerRecordEntry DEFAULT = new PlayerRecordEntry(Util.f_137441_, "", 6000);
        private final UUID playerUUID;
        private final String playerName;
        private final int tickCount;

        public PlayerRecordEntry(UUID playerUUID, String playerName, int tickCount) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.tickCount = tickCount;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("playerUUID", this.playerUUID);
            tag.m_128359_("playerName", this.playerName);
            tag.m_128405_("tickCount", this.tickCount);
            return tag;
        }

        public static PlayerRecordEntry deserialize(CompoundTag tag) {
            return new PlayerRecordEntry(tag.m_128342_("playerUUID"), tag.m_128461_("playerName"), tag.m_128451_("tickCount"));
        }
    }
}

