/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class RoyaleSkillSnapshotData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_RoyaleSkillSnapshots";
    private final VMapNBT<UUID, SkillSnapshot> snapshots = VMapNBT.ofUUID(SkillSnapshot::new);

    public void putSnapshot(UUID player, PlayerVaultStats statsData, AbilityTree abilities, TalentTree talents) {
        SkillSnapshot snapshot = new SkillSnapshot();
        snapshot.abilities = (AbilityTree)abilities.copy();
        snapshot.talents = (TalentTree)talents.copy();
        snapshot.skillPoints = statsData.getUnspentSkillPoints();
        snapshot.prestigePoints = statsData.getUnspentPrestigePoints();
        this.snapshots.put(player, snapshot);
        this.m_77762_();
    }

    public SkillSnapshot removeSnapshot(UUID player) {
        SkillSnapshot removed = this.snapshots.remove(player);
        if (removed != null) {
            this.m_77762_();
        }
        return removed;
    }

    public boolean hasSnapshot(UUID player) {
        return this.snapshots.containsKey(player);
    }

    public static RoyaleSkillSnapshotData get(ServerLevel world) {
        return RoyaleSkillSnapshotData.get(world.m_142572_());
    }

    public static RoyaleSkillSnapshotData get(MinecraftServer server) {
        return (RoyaleSkillSnapshotData)server.m_129783_().m_8895_().m_164861_(RoyaleSkillSnapshotData::create, RoyaleSkillSnapshotData::new, DATA_NAME);
    }

    private static RoyaleSkillSnapshotData create(CompoundTag tag) {
        RoyaleSkillSnapshotData data = new RoyaleSkillSnapshotData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.snapshots.deserializeNBT(nbt.m_128437_("snapshots", 10));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("snapshots", (Tag)this.snapshots.serializeNBT());
        return nbt;
    }

    public static class SkillSnapshot
    implements INBTSerializable<CompoundTag> {
        private int skillPoints;
        private int prestigePoints;
        private AbilityTree abilities = new AbilityTree();
        private TalentTree talents = new TalentTree();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.abilities.writeNbt().ifPresent(a -> tag.m_128365_("abilities", (Tag)a));
            this.talents.writeNbt().ifPresent(t -> tag.m_128365_("talents", (Tag)t));
            tag.m_128405_("skillPoints", this.skillPoints);
            tag.m_128405_("prestigePoints", this.prestigePoints);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.abilities = new AbilityTree();
            this.talents = new TalentTree();
            if (nbt.m_128441_("abilities")) {
                this.abilities.readNbt(nbt.m_128469_("abilities"));
            }
            if (nbt.m_128441_("talents")) {
                this.talents.readNbt(nbt.m_128469_("talents"));
            }
            this.skillPoints = nbt.m_128451_("skillPoints");
            this.prestigePoints = nbt.m_128451_("prestigePoints");
        }

        public AbilityTree getAbilities() {
            return this.abilities;
        }

        public TalentTree getTalents() {
            return this.talents;
        }

        public int getSkillPoints() {
            return this.skillPoints;
        }

        public int getPrestigePoints() {
            return this.prestigePoints;
        }
    }
}

