/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.VHSmpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ScheduledItemDropData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_ScheduledItemDrops";
    private final Map<UUID, List<ItemStack>> scheduledItems = new HashMap<UUID, List<ItemStack>>();

    public void addDrop(Player player, ItemStack toDrop) {
        this.addDrop(player.m_142081_(), toDrop);
    }

    public void addDrop(UUID playerUUID, ItemStack toDrop) {
        this.scheduledItems.computeIfAbsent(playerUUID, key -> new ArrayList()).add(toDrop.m_41777_());
        this.m_77762_();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            ServerPlayer player = (ServerPlayer)event.player;
            if (VHSmpUtil.isArenaWorld((Entity)player)) {
                return;
            }
            ScheduledItemDropData data = ScheduledItemDropData.get(player.m_183503_());
            if (data.scheduledItems.containsKey(player.m_142081_())) {
                List<ItemStack> drops = data.scheduledItems.get(player.m_142081_());
                while (!drops.isEmpty() && MiscUtils.hasEmptySlot((Container)player.m_150109_())) {
                    ItemStack drop = drops.remove(0);
                    player.m_150109_().m_36054_(drop);
                    data.m_77762_();
                }
                if (drops.isEmpty()) {
                    data.scheduledItems.remove(player.m_142081_());
                    data.m_77762_();
                }
            }
        }
    }

    private static ScheduledItemDropData create(CompoundTag tag) {
        ScheduledItemDropData data = new ScheduledItemDropData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag tag) {
        this.scheduledItems.clear();
        CompoundTag savTag = tag.m_128469_("drops");
        for (String key : savTag.m_128431_()) {
            UUID playerUUID;
            try {
                playerUUID = UUID.fromString(key);
            }
            catch (IllegalArgumentException exc) {
                continue;
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ListTag dropsList = savTag.m_128437_(key, 10);
            for (int i = 0; i < dropsList.size(); ++i) {
                drops.add(ItemStack.m_41712_((CompoundTag)dropsList.m_128728_(i)));
            }
            this.scheduledItems.put(playerUUID, drops);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag savTag = new CompoundTag();
        this.scheduledItems.forEach((uuid, drops) -> {
            ListTag dropsList = new ListTag();
            drops.forEach(stack -> dropsList.add((Object)stack.serializeNBT()));
            savTag.m_128365_(uuid.toString(), (Tag)dropsList);
        });
        tag.m_128365_("drops", (Tag)savTag);
        return tag;
    }

    public static ScheduledItemDropData get(ServerLevel world) {
        return ScheduledItemDropData.get(world.m_142572_());
    }

    public static ScheduledItemDropData get(MinecraftServer srv) {
        return (ScheduledItemDropData)srv.m_129783_().m_8895_().m_164861_(ScheduledItemDropData::create, ScheduledItemDropData::new, DATA_NAME);
    }
}

