/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.sync.context.DiskSyncContext;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.threading.ThreadingMode;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.world.data.VaultSnapshots;
import iskallia.vault.world.data.VirtualWorlds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerVaults
extends SavedData {
    protected static final String DATA_NAME = "the_vault_Vaults";
    private final VListNBT<Vault, LongArrayTag> vaults = new VListNBT<Vault, LongArrayTag>(new ArrayList(), vault -> {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        buffer.writeEnum(vault.get(Vault.VERSION));
        vault.write(buffer, new DiskSyncContext(vault.get(Vault.VERSION)));
        return new LongArrayTag(buffer.toLongArray());
    }, nbt -> {
        ArrayBitBuffer buffer = ArrayBitBuffer.backing(nbt.m_128851_(), 0);
        Vault vault = (Vault)new Vault().read(buffer, new DiskSyncContext(buffer.readEnum(Version.class)));
        ServerVaults.getWorld(vault).ifPresent(vault::initServer);
        return vault;
    });

    protected ServerVaults() {
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerVaults.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).vaults.removeIf(vault -> {
            if (vault.has(Vault.FINISHED)) {
                VaultSnapshots.onVaultEnded(vault);
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        ServerVaults.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).vaults.forEach(Vault::releaseServer);
    }

    public static Vault add(Vault vault) {
        ServerVaults.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).vaults.add(vault);
        VirtualWorld world = VirtualWorld.create(ServerVaults.getWorldId(vault), ThreadingMode.CONCURRENT);
        VirtualWorlds.register(world);
        vault.initServer(world);
        VaultSnapshots.onVaultStarted(vault);
        return vault;
    }

    public static ResourceLocation getWorldId(Vault vault) {
        return VaultMod.id("vault_" + vault.get(Vault.ID).toString());
    }

    public static Optional<VirtualWorld> getWorld(Vault vault) {
        if (vault == null) {
            return Optional.empty();
        }
        for (VirtualWorld world : VirtualWorlds.getAll()) {
            if (!ServerVaults.getWorldId(vault).equals((Object)world.m_46472_().m_135782_())) continue;
            return Optional.of(world);
        }
        return Optional.empty();
    }

    public static List<Vault> getAll() {
        return ServerVaults.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).vaults;
    }

    public static Optional<Vault> get(UUID uuid) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server == null ? Optional.empty() : ServerVaults.get((MinecraftServer)server).vaults.stream().filter(vault -> vault.get(Vault.ID).equals(uuid)).findFirst();
    }

    public static Optional<Vault> get(Level world) {
        if (world == null || world.f_46443_) {
            return Optional.empty();
        }
        for (Vault vault : ServerVaults.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).vaults) {
            if (!world.m_46472_().m_135782_().toString().contains(vault.get(Vault.ID).toString())) continue;
            return Optional.of(vault);
        }
        return Optional.empty();
    }

    public static boolean isInVault(Level world) {
        return world.m_46472_().m_135782_().toString().contains("the_vault");
    }

    public static boolean remove(Vault vault) {
        return ServerVaults.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).vaults.remove(vault);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("vaults", (Tag)this.vaults.serializeNBT());
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.vaults.deserializeNBT(nbt.m_128437_("vaults", 12));
    }

    public static ServerVaults get(MinecraftServer server) {
        return (ServerVaults)server.m_129783_().m_8895_().m_164861_(ServerVaults::create, ServerVaults::new, DATA_NAME);
    }

    private static ServerVaults create(CompoundTag tag) {
        ServerVaults data = new ServerVaults();
        data.load(tag);
        return data;
    }
}

