/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.RemoveTeamTasksMessage;
import iskallia.vault.network.message.UpdateAllTeamTasksMessage;
import iskallia.vault.network.message.UpdateTeamTasksMessage;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TeamTaskData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_Team_Tasks";
    public static final TeamTaskData CLIENT_INSTANCE = new TeamTaskData();
    private final Map<String, TeamTasks> allTeamTasks = new HashMap<String, TeamTasks>();
    private final Map<String, String> completedTasks = new HashMap<String, String>();
    private final List<TeamScore> teamScores = new ArrayList<TeamScore>();

    public static TeamTaskData get() {
        return CLIENT_INSTANCE;
    }

    public static TeamTaskData get(MinecraftServer server) {
        return (TeamTaskData)server.m_129783_().m_8895_().m_164861_(TeamTaskData::create, TeamTaskData::new, DATA_NAME);
    }

    private static TeamTaskData create(CompoundTag tag) {
        TeamTaskData data = new TeamTaskData();
        data.load(tag);
        return data;
    }

    private void load(CompoundTag tag) {
        ListTag teamTaskListTag = tag.m_128437_("TeamTasks", 10);
        teamTaskListTag.forEach(teamTaskTag -> {
            CompoundTag teamTasksTag = (CompoundTag)teamTaskTag;
            TeamTasks.readNbt(teamTasksTag.m_128469_("Tasks")).ifPresent(teamTasks -> {
                String teamName = teamTasksTag.m_128461_("Team");
                this.allTeamTasks.put(teamName, (TeamTasks)teamTasks);
            });
        });
        ListTag completedTasksListTag = tag.m_128437_("CompletedTasks", 10);
        completedTasksListTag.forEach(completedTaskTag -> {
            CompoundTag completedTask = (CompoundTag)completedTaskTag;
            this.completedTasks.put(completedTask.m_128461_("TaskId"), completedTask.m_128461_("TeamName"));
        });
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        ListTag teamTaskListTag = new ListTag();
        this.allTeamTasks.forEach((teamName, teamTasks) -> {
            CompoundTag teamTasksTag = new CompoundTag();
            teamTasksTag.m_128359_("Team", teamName);
            teamTasksTag.m_128365_("Tasks", (Tag)teamTasks.writeNbt());
            teamTaskListTag.add((Object)teamTasksTag);
        });
        pCompoundTag.m_128365_("TeamTasks", (Tag)teamTaskListTag);
        ListTag completedTasksListTag = new ListTag();
        this.completedTasks.forEach((taskId, teamName) -> {
            CompoundTag completedTaskTag = new CompoundTag();
            completedTaskTag.m_128359_("TaskId", taskId);
            completedTaskTag.m_128359_("TeamName", teamName);
            completedTasksListTag.add((Object)completedTaskTag);
        });
        pCompoundTag.m_128365_("CompletedTasks", (Tag)completedTasksListTag);
        return pCompoundTag;
    }

    public Map<String, TeamTasks> getAllTeamTasks() {
        return this.allTeamTasks;
    }

    @Nullable
    public TeamTasks getTeamTasks(String teamName) {
        return this.allTeamTasks.get(teamName);
    }

    public TeamTasks removeTeam(String teamName, @Nullable ServerPlayer serverPlayer) {
        if (!this.allTeamTasks.containsKey(teamName)) {
            return null;
        }
        TeamTasks teamTasksRemoved = this.allTeamTasks.remove(teamName);
        teamTasksRemoved.onDetach();
        this.m_77762_();
        if (serverPlayer != null) {
            this.syncRemoved(teamName, serverPlayer);
        }
        return teamTasksRemoved;
    }

    public void removePlayerFromTeam(ServerPlayer serverPlayer, TeamTasks teamTasks) {
        teamTasks.removePlayer(serverPlayer.m_142081_());
        this.setDirtyAndSynchronize(teamTasks, serverPlayer);
    }

    public void addTeamTasks(MinecraftServer server, @Nullable ServerPlayer serverPlayer, String teamName, TeamTasks teamTasks) {
        this.allTeamTasks.put(teamName, teamTasks);
        teamTasks.onAttach(server);
        this.setDirtyAndSynchronize(teamTasks, serverPlayer);
    }

    private void setDirtyAndSynchronize(TeamTasks teamTasks, @Nullable ServerPlayer serverPlayer) {
        this.m_77762_();
        if (serverPlayer != null) {
            this.syncSingle(teamTasks, serverPlayer);
        }
    }

    public void addPlayerToExistingTeam(ServerPlayer serverPlayer, TeamTasks teamTasks) {
        teamTasks.addPlayer(serverPlayer.m_142081_());
        this.setDirtyAndSynchronize(teamTasks, serverPlayer);
    }

    public void addCompletedTask(String taskId, String teamName) {
        this.completedTasks.put(taskId, teamName);
        this.m_77762_();
    }

    private void syncSingle(TeamTasks teamTasks, ServerPlayer serverPlayer) {
        UpdateTeamTasksMessage message = new UpdateTeamTasksMessage(teamTasks);
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message);
    }

    private void syncRemoved(String teamName, ServerPlayer serverPlayer) {
        RemoveTeamTasksMessage message = new RemoveTeamTasksMessage(teamName);
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message);
    }

    public Packet<?> createSyncPacket() {
        return ModNetwork.CHANNEL.toVanillaPacket((Object)new UpdateAllTeamTasksMessage(this.allTeamTasks.values(), this.completedTasks), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void syncAll(ServerPlayer serverPlayer) {
        PacketDistributor.PLAYER.with(() -> serverPlayer).send(this.createSyncPacket());
    }

    public void updateAllTeamTasks(Collection<TeamTasks> teamTasks) {
        this.allTeamTasks.clear();
        teamTasks.forEach(teamTask -> this.allTeamTasks.put(teamTask.teamName, (TeamTasks)teamTask));
    }

    public void updateTeamTasks(TeamTasks teamTasks) {
        this.allTeamTasks.put(teamTasks.teamName, teamTasks);
    }

    public void updateCompletedTasks(Map<String, String> completedTasks) {
        if (!completedTasks.equals(this.completedTasks)) {
            this.completedTasks.clear();
            this.completedTasks.putAll(completedTasks);
            this.updateTeamScores();
        }
    }

    public void removeTeamTasks(String teamName) {
        this.allTeamTasks.remove(teamName);
    }

    public void removeAllTeamTasks() {
        this.completedTasks.clear();
        this.allTeamTasks.values().forEach(TeamTasks::onDetach);
        this.allTeamTasks.clear();
        this.m_77762_();
    }

    public void removeTaskFromTeamTasksExceptForCompletingTeam(String taskId) {
        this.allTeamTasks.values().forEach(teamTasks -> {
            if (this.completedTasks.get(taskId).equals(teamTasks.teamName)) {
                teamTasks.getTask(taskId).ifPresent(Task::onDetach);
                return;
            }
            teamTasks.removeTask(taskId);
        });
        this.m_77762_();
    }

    public Optional<String> getCompletedTaskTeam(String taskId) {
        return Optional.ofNullable(this.completedTasks.get(taskId));
    }

    public Map<String, String> getCompletedTasks() {
        return this.completedTasks;
    }

    public boolean refreshTask(String taskId, MinecraftServer server) {
        if (!this.removeTaskFromTeamsAndCompleted(taskId)) {
            return false;
        }
        Task task = ModConfigs.TEAM_TASKS.getTask(taskId);
        if (task != null) {
            this.allTeamTasks.values().forEach(teamTasks -> teamTasks.addTask((Task)task.copy(), server));
            this.m_77762_();
            this.syncToAllOnlinePlayers(server);
            return true;
        }
        return false;
    }

    private void syncToAllOnlinePlayers(MinecraftServer server) {
        server.m_6846_().m_11314_().forEach(this::syncAll);
    }

    private boolean removeTaskFromTeamsAndCompleted(String taskId) {
        Optional<Task> nextTaskId = ModConfigs.TEAM_TASKS.getNextTask(taskId);
        AtomicBoolean result = new AtomicBoolean(false);
        nextTaskId.ifPresent(task -> {
            if (this.allTeamTasks.values().stream().anyMatch(teamTasks -> teamTasks.hasTask(taskId)) && this.removeTaskFromTeamsAndCompleted(task.getId())) {
                result.set(true);
            }
        });
        this.allTeamTasks.values().forEach(teamTasks -> {
            if (teamTasks.removeTask(taskId)) {
                result.set(true);
            }
        });
        this.completedTasks.remove(taskId);
        return result.get();
    }

    public boolean setTaskProgress(String teamName, String taskId, int progress, MinecraftServer server) {
        TeamTasks teamTasks = this.allTeamTasks.get(teamName);
        if (teamTasks == null) {
            return false;
        }
        return teamTasks.getTask(taskId).map(task -> {
            if (this.setProgressIfProgressTask((Task)task, teamTasks, progress, server)) {
                this.syncToAllOnlinePlayers(server);
                return true;
            }
            for (Task child : task.getChildren()) {
                if (!this.setProgressIfProgressTask(child, teamTasks, progress, server)) continue;
                this.syncToAllOnlinePlayers(server);
                return true;
            }
            return false;
        }).orElse(false);
    }

    private boolean setProgressIfProgressTask(Task task, TeamTasks teamTasks, int progress, MinecraftServer server) {
        TargetTaskCounter targetTaskCounter;
        ProgressConfiguredTask progressTask;
        TaskCounter taskCounter;
        if (task instanceof ProgressConfiguredTask && (taskCounter = (progressTask = (ProgressConfiguredTask)task).getCounter()) instanceof TargetTaskCounter && (targetTaskCounter = (TargetTaskCounter)taskCounter).getCurrent() instanceof Integer) {
            targetTaskCounter.onSet(progress, TaskContext.of(teamTasks.taskSource, server));
            return true;
        }
        return false;
    }

    public Stream<String> streamAssignedTaskIds() {
        return this.allTeamTasks.values().stream().flatMap(teamTasks -> teamTasks.tasks().values().stream()).map(Task::getId).distinct();
    }

    public Set<String> getTeamNames() {
        return this.allTeamTasks.keySet();
    }

    public Map<String, Number> getTaskProgress(String taskId) {
        return this.allTeamTasks.values().stream().map(teamTasks -> teamTasks.getTask(taskId).flatMap(t -> this.getTaskProgress((Task)t).map(progress -> new AbstractMap.SimpleEntry<String, Number>(teamTasks.teamName, (Number)progress)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Number> getTaskProgress(Task task) {
        ProgressConfiguredTask progressTask;
        if (task instanceof ProgressConfiguredTask && (progressTask = (ProgressConfiguredTask)task).getCounter() != null) {
            return Optional.of(progressTask.getProgress().getCurrent());
        }
        for (Task child : task.getChildren()) {
            ProgressConfiguredTask progressChildTask;
            if (!(child instanceof ProgressConfiguredTask) || (progressChildTask = (ProgressConfiguredTask)child).getCounter() == null) continue;
            return Optional.of(progressChildTask.getProgress().getCurrent());
        }
        return Optional.empty();
    }

    public void updateTeamScores() {
        HashMap<String, Set> teamCompletedTasks = new HashMap<String, Set>();
        this.completedTasks.forEach((taskId, teamName) -> teamCompletedTasks.computeIfAbsent((String)teamName, t -> new HashSet()).add(taskId));
        this.teamScores.clear();
        teamCompletedTasks.forEach((teamName, taskIds) -> this.teamScores.add(new TeamScore((String)teamName, (Set<String>)taskIds, Set.of(), Map.of())));
        this.teamScores.sort(Comparator.comparing(ts -> ts.completedTasks().size()).reversed());
    }

    public List<TeamScore> getTeamScores() {
        return this.teamScores;
    }

    public static final class TeamTasks {
        private final String teamName;
        private final EntityTaskSource taskSource;
        private final Map<String, Task> tasks;
        private boolean tasksAttached = false;

        public TeamTasks(String teamName, EntityTaskSource taskSource, Map<String, Task> tasks) {
            this.teamName = teamName;
            this.taskSource = taskSource;
            this.tasks = tasks;
        }

        public boolean playerInTeam(UUID playerId) {
            return this.taskSource.getUuids().contains(playerId);
        }

        public Optional<Task> getTask(String taskId) {
            return Optional.ofNullable(this.tasks.get(taskId));
        }

        public void onDetach() {
            this.tasks.values().forEach(Task::onDetach);
            this.tasksAttached = false;
        }

        public void onAttach(MinecraftServer server) {
            if (this.tasksAttached) {
                return;
            }
            this.tasks.values().forEach(task -> task.onAttach(TaskContext.of(this.taskSource, server)));
            this.tasksAttached = true;
        }

        public void removePlayer(UUID playerId) {
            this.taskSource.remove(playerId);
        }

        public void addPlayer(UUID playerId) {
            this.taskSource.add(playerId);
        }

        public int getNumberOfPlayers() {
            return this.taskSource.getUuids().size();
        }

        public boolean hasTask(String taskId) {
            return this.tasks.containsKey(taskId);
        }

        public void addTask(Task task, MinecraftServer server) {
            this.tasks.put(task.getId(), task);
            if (this.tasksAttached) {
                task.onAttach(TaskContext.of(this.taskSource, server));
            }
        }

        public static Optional<TeamTasks> readNbt(CompoundTag tag) {
            Optional<TaskSource> taskSource = Adapters.TASK_SOURCE_NBT.readNbt((Tag)tag.m_128469_("TaskSource"));
            return taskSource.filter(EntityTaskSource.class::isInstance).map(source -> {
                String teamName = tag.m_128461_("Team");
                HashMap<String, Task> tasks = new HashMap<String, Task>();
                ListTag taskListTag = tag.m_128437_("Tasks", 10);
                taskListTag.forEach(taskTag -> Adapters.TASK_NBT.readNbt((Tag)taskTag).ifPresent(task -> tasks.put(task.getId(), (Task)task)));
                return new TeamTasks(teamName, (EntityTaskSource)source, tasks);
            });
        }

        public CompoundTag writeNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Team", this.teamName);
            Adapters.TASK_SOURCE_NBT.writeNbt(this.taskSource).ifPresent(taskSourceTag -> tag.m_128365_("TaskSource", taskSourceTag));
            ListTag taskListTag = new ListTag();
            this.tasks.values().forEach(task -> Adapters.TASK_NBT.writeNbt((Task)task).ifPresent(arg_0 -> taskListTag.add(arg_0)));
            tag.m_128365_("Tasks", (Tag)taskListTag);
            return tag;
        }

        public void writeBytes(FriendlyByteBuf buffer) {
            ArrayBitBuffer bits = ArrayBitBuffer.empty();
            buffer.m_130070_(this.teamName);
            buffer.m_130130_(this.tasks.size());
            this.tasks.values().forEach(task -> Adapters.TASK.writeBits(task, (BitBuffer)bits));
            Adapters.TASK_SOURCE.writeBits(this.taskSource, (BitBuffer)bits);
            buffer.m_130091_(bits.toLongArray());
        }

        public static TeamTasks readBytes(FriendlyByteBuf buffer) {
            String teamName = buffer.m_130277_();
            HashMap<String, Task> tasks = new HashMap<String, Task>();
            int size = buffer.m_130242_();
            ArrayBitBuffer bits = ArrayBitBuffer.backing(buffer.m_178381_(), 0);
            for (int i = 0; i < size; ++i) {
                Adapters.TASK.readBits(bits).ifPresent(task -> tasks.put(task.getId(), (Task)task));
            }
            TaskSource taskSource = (TaskSource)Adapters.TASK_SOURCE.readBits(bits).orElseThrow();
            return new TeamTasks(teamName, (EntityTaskSource)taskSource, tasks);
        }

        public String teamName() {
            return this.teamName;
        }

        public EntityTaskSource taskSource() {
            return this.taskSource;
        }

        public Map<String, Task> tasks() {
            return this.tasks;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TeamTasks that = (TeamTasks)obj;
            return Objects.equals(this.teamName, that.teamName) && Objects.equals(this.taskSource, that.taskSource) && Objects.equals(this.tasks, that.tasks);
        }

        public int hashCode() {
            return Objects.hash(this.teamName, this.taskSource, this.tasks);
        }

        public String toString() {
            return "TeamTasks[teamName=" + this.teamName + ", taskSource=" + String.valueOf(this.taskSource) + ", tasks=" + String.valueOf(this.tasks) + "]";
        }

        public List<Task> getCompletedTasks() {
            return this.tasks.values().stream().filter(Task::isCompleted).toList();
        }

        public boolean removeTask(String taskId) {
            Task task = this.tasks.remove(taskId);
            if (task != null) {
                task.onDetach();
                return true;
            }
            return false;
        }
    }

    public record TeamScore(String teamName, Set<String> completedTasks, Set<String> currentlyClaimedTasks, Map<String, Integer> bonusPoints) {
    }
}

