/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.world.data.InventorySnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class TimestampedInventorySnapshotData
extends SavedData {
    public VMapNBT<UUID, TimestampedInventorySnapshot> snapshotData = VMapNBT.ofUUID(TimestampedInventorySnapshot::new);

    protected InventorySnapshot.Builder makeSnapshotBuilder(Player player) {
        return new InventorySnapshot.Builder(player).setStackFilter((p, stack) -> true);
    }

    public void createSnapshot(Player player) {
        TimestampedInventorySnapshot timestampedSnapshots = (TimestampedInventorySnapshot)this.snapshotData.computeIfAbsent(player.m_142081_(), u -> new TimestampedInventorySnapshot());
        timestampedSnapshots.addSnapshot((int)(Util.m_137574_() / 1000L), this.makeSnapshotBuilder(player).createSnapshot());
        this.m_77762_();
    }

    public void removeLastSnapshot(ServerPlayer player) {
        this.snapshotData.computeIfPresent(player.m_142081_(), (playerUuid, snapshots) -> {
            if (!snapshots.timestampedSnapshots.isEmpty()) {
                ArrayList<Integer> timestamps = new ArrayList<Integer>(snapshots.getTimestamps());
                timestamps.sort(Comparator.reverseOrder());
                snapshots.timestampedSnapshots.remove(timestamps.get(0));
                this.m_77762_();
            }
            return snapshots;
        });
    }

    public boolean removeSnapshots(Player player) {
        return this.removeSnapshots(player.m_142081_());
    }

    public boolean removeSnapshots(UUID playerUUID) {
        if (this.snapshotData.remove(playerUUID) != null) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public Set<Integer> getSnapshotTimestamps(UUID playerUuid) {
        if (!this.snapshotData.containsKey(playerUuid)) {
            return Collections.emptySet();
        }
        return this.snapshotData.get(playerUuid).getTimestamps();
    }

    public Optional<InventorySnapshot> getLastSnapshot(UUID playerUuid) {
        if (!this.snapshotData.containsKey(playerUuid)) {
            return Optional.empty();
        }
        TimestampedInventorySnapshot snapshots = this.snapshotData.get(playerUuid);
        return snapshots.getTimestamps().stream().max(Integer::compareTo).flatMap(snapshots::getSnapshot);
    }

    public boolean restoreSnapshot(Player applyToPlayer, UUID playerUuid, int timestamp) {
        if (this.snapshotData.containsKey(playerUuid)) {
            TimestampedInventorySnapshot timestampedSnapshots = this.snapshotData.get(playerUuid);
            return timestampedSnapshots.getSnapshot(timestamp).map(snapshot -> snapshot.apply(applyToPlayer)).orElse(false);
        }
        return false;
    }

    public void load(CompoundTag nbt) {
        this.snapshotData.deserializeNBT(nbt.m_128437_("Players", 10));
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_("Players", (Tag)this.snapshotData.serializeNBT());
        return compound;
    }

    public static class TimestampedInventorySnapshot
    implements INBTSerializable<CompoundTag> {
        private final VMapNBT<Integer, InventorySnapshot> timestampedSnapshots = VMapNBT.ofInt(InventorySnapshot::new);

        TimestampedInventorySnapshot() {
        }

        public void addSnapshot(int timestamp, InventorySnapshot snapshot) {
            this.timestampedSnapshots.put(timestamp, snapshot);
            ArrayList<Integer> timestamps = new ArrayList<Integer>(this.timestampedSnapshots.keySet());
            timestamps.sort(Comparator.reverseOrder());
            for (int i = 10; i < timestamps.size(); ++i) {
                this.timestampedSnapshots.remove(timestamps.get(i));
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("timestampedSnapshots", (Tag)this.timestampedSnapshots.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.timestampedSnapshots.deserializeNBT(nbt.m_128437_("timestampedSnapshots", 10));
        }

        public Optional<InventorySnapshot> getSnapshot(int timestamp) {
            return Optional.ofNullable(this.timestampedSnapshots.get(timestamp));
        }

        public Set<Integer> getTimestamps() {
            return this.timestampedSnapshots.keySet();
        }
    }
}

