/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.core.data.compound.UUIDXpMap;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.world.VaultPartyExpSharing;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VaultPartyExpData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultPartyExp";
    private final Map<UUID, Map<UUID, Integer>> vaultExpMap = new HashMap<UUID, Map<UUID, Integer>>();

    public static VaultPartyExpData get(ServerLevel world) {
        return VaultPartyExpData.get(world.m_142572_());
    }

    public static VaultPartyExpData get(MinecraftServer server) {
        return (VaultPartyExpData)server.m_129783_().m_8895_().m_164861_(VaultPartyExpData::create, VaultPartyExpData::new, DATA_NAME);
    }

    private static VaultPartyExpData create(CompoundTag tag) {
        VaultPartyExpData data = new VaultPartyExpData();
        data.load(tag);
        return data;
    }

    public void addPlayerXp(UUID vaultId, UUID playerId, int experience) {
        Map playerXpMap = this.vaultExpMap.computeIfAbsent(vaultId, id -> new HashMap());
        playerXpMap.put(playerId, playerXpMap.getOrDefault(playerId, 0) + experience);
        this.m_77762_();
    }

    public int getDistributionXP(UUID vaultId, VaultPartyExpSharing xpSharingMode) {
        UUIDXpMap xpMap = this.getVaultXpMap(vaultId);
        if (xpMap.isEmpty()) {
            VaultMod.LOGGER.error("No XP data found for vault: " + String.valueOf(vaultId));
            return 0;
        }
        int totalExp = 0;
        int highestExp = 0;
        int lowestExp = Integer.MAX_VALUE;
        for (Map.Entry entry : xpMap.entrySet()) {
            int exp = (Integer)entry.getValue();
            totalExp += exp;
            highestExp = Math.max(highestExp, exp);
            lowestExp = Math.min(lowestExp, exp);
        }
        int averageExp = totalExp / xpMap.size();
        return switch (xpSharingMode) {
            case VaultPartyExpSharing.HIGHEST -> highestExp;
            case VaultPartyExpSharing.LOWEST -> lowestExp;
            case VaultPartyExpSharing.AVERAGE -> averageExp;
            default -> 0;
        };
    }

    public void distributeXp(VirtualWorld world, UUID vaultId, int sharedExp) {
        UUIDXpMap xpMap = this.getVaultXpMap(vaultId);
        if (xpMap.isEmpty() || xpMap.size() <= 1) {
            return;
        }
        for (UUID playerId : xpMap.keySet()) {
            ServerPlayer player = world.m_142572_().m_6846_().m_11259_(playerId);
            PlayerVaultStatsData statsData = PlayerVaultStatsData.get(world.m_142572_());
            if (player != null) {
                statsData.addVaultExp(player, sharedExp);
                CompanionItem.grantVaultCompletionXP((Player)player, sharedExp);
                MutableComponent message = new TextComponent("You have received ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent("" + sharedExp).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD))).m_7220_((Component)new TextComponent(" vault experience from your shared vault!").m_130940_(ChatFormatting.GRAY));
                player.m_6352_((Component)message, player.m_142081_());
                continue;
            }
            PlayerVaultStats playerStats = statsData.getVaultStats(playerId);
            playerStats.addVaultExp(world.m_142572_(), sharedExp);
        }
    }

    public UUIDXpMap getVaultXpMap(UUID vaultId) {
        Map<UUID, Integer> playerXpMap = this.vaultExpMap.get(vaultId);
        if (playerXpMap == null) {
            return UUIDXpMap.create();
        }
        UUIDXpMap result = UUIDXpMap.create();
        result.putAll(playerXpMap);
        return result;
    }

    public boolean hasVaultData(UUID vaultId) {
        Map<UUID, Integer> map = this.vaultExpMap.get(vaultId);
        return map != null && !map.isEmpty();
    }

    public void removeVaultData(UUID vaultId) {
        this.vaultExpMap.remove(vaultId);
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag vaultsTag = new CompoundTag();
        this.vaultExpMap.forEach((vaultId, playerXpMap) -> {
            CompoundTag vaultTag = new CompoundTag();
            CompoundTag playersTag = new CompoundTag();
            playerXpMap.forEach((playerId, xp) -> playersTag.m_128405_(playerId.toString(), xp.intValue()));
            vaultTag.m_128365_("players", (Tag)playersTag);
            vaultsTag.m_128365_(vaultId.toString(), (Tag)vaultTag);
        });
        nbt.m_128365_("vaultExp", (Tag)vaultsTag);
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.vaultExpMap.clear();
        if (nbt.m_128425_("vaultExp", 10)) {
            CompoundTag vaultsTag = nbt.m_128469_("vaultExp");
            for (String vaultIdStr : vaultsTag.m_128431_()) {
                try {
                    UUID vaultId = UUID.fromString(vaultIdStr);
                    CompoundTag vaultTag = vaultsTag.m_128469_(vaultIdStr);
                    if (!vaultTag.m_128425_("players", 10)) continue;
                    CompoundTag playersTag = vaultTag.m_128469_("players");
                    HashMap<UUID, Integer> playerXpMap = new HashMap<UUID, Integer>();
                    for (String playerIdStr : playersTag.m_128431_()) {
                        try {
                            UUID playerId = UUID.fromString(playerIdStr);
                            int xp = playersTag.m_128451_(playerIdStr);
                            playerXpMap.put(playerId, xp);
                        }
                        catch (IllegalArgumentException e) {
                            VaultMod.LOGGER.error("Failed to parse player UUID: " + playerIdStr, (Throwable)e);
                        }
                    }
                    if (playerXpMap.isEmpty()) continue;
                    this.vaultExpMap.put(vaultId, playerXpMap);
                }
                catch (IllegalArgumentException e) {
                    VaultMod.LOGGER.error("Failed to parse vault UUID: " + vaultIdStr, (Throwable)e);
                }
            }
        }
    }
}

