/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CompassItem;
import iskallia.vault.item.VaultCompassMode;
import iskallia.vault.network.message.ClientboundCompassDataSyncMessage;
import iskallia.vault.research.StageManager;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class VaultPlayerCompassData
extends SavedData {
    private static final String DATA_NAME = "the_vault_PlayerCompass";
    private final Map<UUID, CompassInfo> playerCompassMap = new HashMap<UUID, CompassInfo>();
    public static final VaultPlayerCompassData CLIENT = new VaultPlayerCompassData();

    public CompassInfo get(UUID playerId) {
        return this.playerCompassMap.computeIfAbsent(playerId, uuid -> new CompassInfo());
    }

    public void saveToPlayer(UUID playerId, CompassInfo compassInfo) {
        this.playerCompassMap.put(playerId, compassInfo);
        this.m_77762_();
    }

    public void saveToPlayer(ServerPlayer playerId, CompassInfo compassInfo) {
        this.saveToPlayer(playerId.m_142081_(), compassInfo);
        this.sync(playerId, compassInfo);
    }

    public void sync(ServerPlayer player, CompassInfo info) {
        ModNetwork.CHANNEL.sendTo((Object)new ClientboundCompassDataSyncMessage(info), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void load(CompoundTag savedDataTag) {
        this.playerCompassMap.clear();
        ListTag playerIdList = savedDataTag.m_128437_("Players", 8);
        ListTag compassInfoList = savedDataTag.m_128437_("Infos", 10);
        for (int playerIndex = 0; playerIndex < playerIdList.size() && playerIndex < compassInfoList.size(); ++playerIndex) {
            UUID playerId = UUID.fromString(playerIdList.m_128778_(playerIndex));
            CompassInfo compassInfo = new CompassInfo();
            compassInfo.deserializeNBT(compassInfoList.m_128728_(playerIndex));
            this.playerCompassMap.put(playerId, compassInfo);
        }
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag outputTag) {
        ListTag playerIdList = new ListTag();
        ListTag compassInfoList = new ListTag();
        this.playerCompassMap.forEach((playerId, compassInfo) -> {
            playerIdList.add((Object)StringTag.m_129297_((String)playerId.toString()));
            compassInfoList.add((Object)compassInfo.serializeNBT());
        });
        outputTag.m_128365_("Players", (Tag)playerIdList);
        outputTag.m_128365_("Infos", (Tag)compassInfoList);
        return outputTag;
    }

    public static VaultPlayerCompassData get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return (VaultPlayerCompassData)server.m_129783_().m_8895_().m_164861_(VaultPlayerCompassData::new, VaultPlayerCompassData::new, DATA_NAME);
    }

    public VaultPlayerCompassData() {
    }

    public VaultPlayerCompassData(CompoundTag savedDataTag) {
        this.load(savedDataTag);
    }

    public void addProgress(UUID playerId, VaultCompassMode compassMode, int progressAmount) {
        CompassInfo info = this.get(playerId);
        info.addProgress(compassMode, progressAmount);
        this.saveToPlayer(playerId, info);
    }

    public static void addProgress(ServerPlayer player, VaultCompassMode compassMode, int progressAmount) {
        if (!StageManager.getResearchTree((Player)player).isResearched("Vault Compass")) {
            return;
        }
        if (CompassItem.getCompass((Player)player).isEmpty()) {
            return;
        }
        VaultPlayerCompassData data = VaultPlayerCompassData.get();
        CompassInfo info = data.get(player.m_142081_());
        if (info.isUnlocked(compassMode)) {
            return;
        }
        int old = info.getProgress(compassMode);
        int req = compassMode.getRequirement();
        int newProgress = old + progressAmount;
        info.setProgress(compassMode, newProgress);
        if (newProgress >= req) {
            info.unlock(compassMode);
            player.m_6352_((Component)new TextComponent("Unlocked compass mode: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)new TextComponent(compassMode.getDisplayName()).m_130940_(ChatFormatting.YELLOW)), player.m_142081_());
        }
        data.saveToPlayer(player, info);
    }

    public static class CompassInfo
    implements INBTSerializable<CompoundTag> {
        private VaultCompassMode currentMode = VaultCompassMode.EXIT;
        private final Set<VaultCompassMode> unlockedModes = EnumSet.of(VaultCompassMode.EXIT);
        private final EnumMap<VaultCompassMode, Integer> modeProgress = new EnumMap(VaultCompassMode.class);
        private int penaltyStacks;

        public VaultCompassMode getMode() {
            return this.currentMode;
        }

        public void setMode(VaultCompassMode mode) {
            this.currentMode = mode;
        }

        public int getPenaltyStacks() {
            return this.penaltyStacks;
        }

        public void incrementPenaltyStacks() {
            ++this.penaltyStacks;
        }

        public void resetPenaltyStacks() {
            this.penaltyStacks = 0;
        }

        public VaultCompassMode cycleMode() {
            VaultCompassMode[] availableModes = VaultCompassMode.values();
            int currentIndex = (this.currentMode.ordinal() + 1) % availableModes.length;
            while (!this.unlockedModes.contains((Object)availableModes[currentIndex])) {
                currentIndex = (currentIndex + 1) % availableModes.length;
            }
            this.currentMode = availableModes[currentIndex];
            return this.currentMode;
        }

        public void addProgress(VaultCompassMode compassMode, int progressAmount) {
            int currentProgress = this.modeProgress.getOrDefault((Object)compassMode, 0) + progressAmount;
            this.modeProgress.put(compassMode, currentProgress);
            if (currentProgress >= compassMode.getRequirement()) {
                this.unlockedModes.add(compassMode);
            }
        }

        public boolean isUnlocked(VaultCompassMode compassMode) {
            return this.unlockedModes.contains((Object)compassMode);
        }

        public void unlock(VaultCompassMode compassMode) {
            this.unlockedModes.add(compassMode);
            this.modeProgress.put(compassMode, compassMode.getRequirement());
        }

        public void lock(VaultCompassMode compassMode) {
            this.unlockedModes.remove((Object)compassMode);
        }

        public int getProgress(VaultCompassMode compassMode) {
            return this.modeProgress.getOrDefault((Object)compassMode, 0);
        }

        public void setProgress(VaultCompassMode compassMode, int progressAmount) {
            this.modeProgress.put(compassMode, progressAmount);
            if (progressAmount >= compassMode.getRequirement()) {
                this.unlockedModes.add(compassMode);
            } else {
                this.unlockedModes.remove((Object)compassMode);
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag compassDataTag = new CompoundTag();
            compassDataTag.m_128359_("Mode", this.currentMode.name());
            ListTag unlockedModesList = new ListTag();
            for (VaultCompassMode unlockedMode : this.unlockedModes) {
                unlockedModesList.add((Object)StringTag.m_129297_((String)unlockedMode.name()));
            }
            compassDataTag.m_128365_("Unlocked", (Tag)unlockedModesList);
            ListTag progressDataList = new ListTag();
            this.modeProgress.forEach((compassMode, progressValue) -> {
                CompoundTag progressEntryTag = new CompoundTag();
                progressEntryTag.m_128359_("mode", compassMode.name());
                progressEntryTag.m_128405_("value", progressValue.intValue());
                progressDataList.add((Object)progressEntryTag);
            });
            compassDataTag.m_128365_("Progress", (Tag)progressDataList);
            compassDataTag.m_128405_("PenaltyStacks", this.penaltyStacks);
            return compassDataTag;
        }

        public void deserializeNBT(CompoundTag compassDataTag) {
            this.currentMode = VaultCompassMode.valueOf(compassDataTag.m_128461_("Mode"));
            this.unlockedModes.clear();
            ListTag unlockedModesList = compassDataTag.m_128437_("Unlocked", 8);
            for (int modeIndex = 0; modeIndex < unlockedModesList.size(); ++modeIndex) {
                this.unlockedModes.add(VaultCompassMode.valueOf(unlockedModesList.m_128778_(modeIndex)));
            }
            this.modeProgress.clear();
            ListTag progressDataList = compassDataTag.m_128437_("Progress", 10);
            for (int progressIndex = 0; progressIndex < progressDataList.size(); ++progressIndex) {
                CompoundTag progressEntryTag = progressDataList.m_128728_(progressIndex);
                VaultCompassMode compassMode = VaultCompassMode.valueOf(progressEntryTag.m_128461_("mode"));
                int progressValue = progressEntryTag.m_128451_("value");
                this.modeProgress.put(compassMode, progressValue);
            }
            this.penaltyStacks = compassDataTag.m_128425_("PenaltyStacks", 3) ? Math.max(0, compassDataTag.m_128451_("PenaltyStacks")) : 0;
        }
    }
}

