/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.compound.UUIDXpMap;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.network.message.VaultPlayerStatsMessage;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.VaultPartyExpSharing;
import iskallia.vault.world.data.PlayerSpiritRecoveryData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultPartyExpData;
import iskallia.vault.world.data.VaultSnapshots;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VaultPlayerStats
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultPlayerStats";
    private final VMapNBT<UUID, Entry> pending = VMapNBT.ofUUID(Entry::new);

    public static void addStats(UUID playerId, UUID vaultId) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ((Entry)VaultPlayerStats.get((MinecraftServer)server).pending.computeIfAbsent((Object)playerId, (Function<UUID, Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addStats$0(java.util.UUID ), (Ljava/util/UUID;)Liskallia/vault/world/data/VaultPlayerStats$Entry;)())).vaultIds.add(vaultId);
        ServerPlayer player = server.m_6846_().m_11259_(playerId);
        if (player == null) {
            return;
        }
        ServerScheduler.INSTANCE.schedule(1, () -> VaultPlayerStats.prompt(player));
        VaultPlayerStats.get(server).m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("pending", (Tag)this.pending.serializeNBT());
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.pending.deserializeNBT(nbt.m_128437_("pending", 10));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && !(player = (ServerPlayer)player2).m_21224_()) {
            VaultPlayerStats.prompt((ServerPlayer)event.getPlayer());
        }
    }

    public static void prompt(ServerPlayer player) {
        VListNBT<UUID, StringTag> ids = ((Entry)VaultPlayerStats.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).pending.getOrDefault((Object)player.m_142081_(), (Object)new Entry())).vaultIds;
        for (UUID id : ids) {
            VaultSnapshot snapshot = VaultPlayerStats.getSnapshot(id).orElse(null);
            if (snapshot == null) continue;
            ModNetwork.CHANNEL.sendTo((Object)new VaultPlayerStatsMessage.S2C(snapshot), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void consume(ServerPlayer player, UUID vaultId) {
        VListNBT<UUID, StringTag> ids = ((Entry)VaultPlayerStats.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).pending.getOrDefault((Object)player.m_142081_(), (Object)new Entry())).vaultIds;
        if (!ids.contains(vaultId)) {
            return;
        }
        VaultSnapshot snapshot = VaultPlayerStats.getSnapshot(vaultId).orElse(null);
        if (snapshot == null || !snapshot.getEnd().has(Vault.STATS)) {
            return;
        }
        StatCollector stats = snapshot.getEnd().get(Vault.STATS).get(player.m_142081_());
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(player.m_183503_());
        int experience = 0;
        VaultPartyExpSharing partyExpSharing = ((VaultPartyExpSharing.GameRuleValue)ServerLifecycleHooks.getCurrentServer().m_129900_().m_46170_(ModGameRules.PARTY_EXP_SHARING)).get();
        Optional<Vault> optVault = ServerVaults.get(vaultId);
        if (partyExpSharing == VaultPartyExpSharing.DISABLED) {
            experience = stats.getExperience(snapshot.getEnd());
        } else if (optVault.isEmpty()) {
            UUIDXpMap xpMap = VaultPartyExpData.get(player.m_183503_().m_142572_()).getVaultXpMap(vaultId);
            if (xpMap.size() <= 1) {
                experience = stats.getExperience(snapshot.getEnd());
                VaultPartyExpData.get(player.m_183503_().m_142572_()).removeVaultData(vaultId);
            }
        } else {
            experience = 0;
        }
        statsData.addVaultExp(player, experience);
        VaultDollItem.onVaultCompletion((Player)player, vaultId, VaultPlayerStats.getSnapshot(vaultId).map(vault -> vault.getEnd().get(Vault.LEVEL).get()).orElse(0), experience);
        CompanionItem.grantVaultCompletionXP((Player)player, experience);
        if (stats.getCompletion() == Completion.COMPLETED) {
            PlayerSpiritRecoveryData.get(player.m_183503_()).decreaseMultiplierOnCompletion(player.m_142081_());
        }
        for (ItemStack stack : stats.get(StatCollector.REWARD)) {
            player.m_150109_().m_150079_(stack.m_41777_());
        }
        ids.remove(vaultId);
        VaultPlayerStats.prompt(player);
        VaultPlayerStats.get(ServerLifecycleHooks.getCurrentServer()).m_77762_();
    }

    public static Optional<VaultSnapshot> getSnapshot(UUID vaultId) {
        VaultSnapshot snapshot = VaultSnapshots.get(vaultId);
        Vault end = null;
        if (snapshot != null) {
            end = snapshot.getEnd() == null ? (Vault)ServerVaults.get(vaultId).orElse(null) : snapshot.getEnd();
        }
        return end == null ? Optional.empty() : Optional.of(new VaultSnapshot(snapshot.getVersion(), snapshot.getStart(), end));
    }

    public static VaultPlayerStats get(MinecraftServer server) {
        return (VaultPlayerStats)server.m_129783_().m_8895_().m_164861_(VaultPlayerStats::create, VaultPlayerStats::new, DATA_NAME);
    }

    private static VaultPlayerStats create(CompoundTag tag) {
        VaultPlayerStats data = new VaultPlayerStats();
        data.load(tag);
        return data;
    }

    private static /* synthetic */ Entry lambda$addStats$0(UUID uuid) {
        return new Entry();
    }

    private static class Entry
    implements INBTSerializable<CompoundTag> {
        public VListNBT<UUID, StringTag> vaultIds = VListNBT.ofUUID();

        private Entry() {
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("vaultIds", (Tag)this.vaultIds.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.vaultIds.deserializeNBT(nbt.m_128437_("vaultIds", 8));
        }
    }
}

