/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.nbt.VListNBT;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultSnapshots
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultSnapshots";
    private final VListNBT<VaultSnapshot, LongArrayTag> snapshots = new VListNBT<VaultSnapshot, LongArrayTag>(new ArrayList(), snapshot -> new LongArrayTag(snapshot.getCache()), nbt -> new VaultSnapshot(ArrayBitBuffer.backing(nbt.m_128851_(), 0)));

    public static VaultSnapshot get(UUID vaultId) {
        VListNBT<VaultSnapshot, LongArrayTag> snapshots = VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots;
        for (VaultSnapshot snapshot : snapshots) {
            if (!snapshot.getStart().get(Vault.ID).equals(vaultId)) continue;
            return snapshot;
        }
        return null;
    }

    public static List<VaultSnapshot> getPrev50(UUID owner, List<VaultSnapshot> snapshots) {
        ArrayList<VaultSnapshot> copy = new ArrayList<VaultSnapshot>(snapshots);
        ArrayList<VaultSnapshot> snapshotToReturn = new ArrayList<VaultSnapshot>();
        for (VaultSnapshot snapshot : copy) {
            if (!snapshot.getEnd().get(Vault.STATS).getMap().containsKey(owner)) continue;
            snapshotToReturn.add(snapshot);
            if (snapshotToReturn.size() < 50) continue;
            break;
        }
        return snapshotToReturn;
    }

    public static List<VaultSnapshot> getAll() {
        return VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots;
    }

    public static void onVaultStarted(Vault vault) {
        VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots.add(new VaultSnapshot(vault.get(Vault.VERSION)).setStart(vault));
        VaultSnapshots.get(ServerLifecycleHooks.getCurrentServer()).m_77762_();
    }

    public static void onVaultEnded(Vault vault) {
        VListNBT<VaultSnapshot, LongArrayTag> snapshots = VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots;
        for (int i = snapshots.size() - 1; i >= 0; --i) {
            VaultSnapshot snapshot = (VaultSnapshot)snapshots.get(i);
            if (!snapshot.matches(vault)) continue;
            snapshot.setEnd(vault);
            snapshot.setTimestamp(Instant.now().getEpochSecond());
            break;
        }
        VaultSnapshots.get(ServerLifecycleHooks.getCurrentServer()).m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("snapshots", (Tag)this.snapshots.serializeNBT());
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.snapshots.deserializeNBT(nbt.m_128437_("snapshots", 12));
    }

    public void m_77757_(File file) {
        if (this.m_77764_()) {
            long start = System.nanoTime();
            try (FileOutputStream fos = new FileOutputStream(file);
                 FileChannel channel = fos.getChannel();){
                ArrayOutputStream array = new ArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(array);
                CompoundTag nbt = new CompoundTag();
                nbt.m_128365_("data", (Tag)this.m_7176_(new CompoundTag()));
                nbt.m_128405_("DataVersion", SharedConstants.m_183709_().getWorldVersion());
                NbtIo.m_128941_((CompoundTag)nbt, (DataOutput)dos);
                ByteBuffer buffer = ByteBuffer.wrap(array.getBuf(), 0, array.getCount());
                channel.write(buffer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
            if (srv != null && srv.m_129900_().m_46207_(ModGameRules.PRINT_SAVE_DATA_TIMING)) {
                long time = System.nanoTime() - start;
                VaultMod.LOGGER.info("VaultSnapshots saving took %f ms".formatted((double)time / 1000000.0));
            }
            this.m_77760_(false);
        }
    }

    public static VaultSnapshots get(MinecraftServer server) {
        return (VaultSnapshots)server.m_129783_().m_8895_().m_164861_(VaultSnapshots::create, VaultSnapshots::new, DATA_NAME);
    }

    private static VaultSnapshots create(CompoundTag tag) {
        VaultSnapshots data = new VaultSnapshots();
        data.load(tag);
        return data;
    }

    public static class ArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

