/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundSpectatorStatusMessage;
import iskallia.vault.world.SpectatorMode;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultPartyData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultSpectatorData
extends SavedData {
    private static final String DATA_NAME = "the_vault_SpectatorData";
    private final Map<UUID, Set<UUID>> playersInSpectatorMode = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, BlockPos> spectatorPositions = new HashMap<UUID, BlockPos>();
    private final Map<UUID, Set<UUID>> spectatorsTargets = new HashMap<UUID, Set<UUID>>();

    public static VaultSpectatorData get(ServerLevel level) {
        return VaultSpectatorData.get(level.m_142572_());
    }

    public static VaultSpectatorData get(MinecraftServer srv) {
        return (VaultSpectatorData)srv.m_129783_().m_8895_().m_164861_(VaultSpectatorData::load, VaultSpectatorData::new, DATA_NAME);
    }

    public boolean forceSave() {
        try {
            this.m_77762_();
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return false;
            }
            File dataDirectory = new File("world", "data");
            File dataFile = new File(dataDirectory, "the_vault_SpectatorData.dat");
            if (!dataDirectory.exists()) {
                dataDirectory.mkdirs();
            }
            CompoundTag tag = new CompoundTag();
            CompoundTag dataTag = this.m_7176_(new CompoundTag());
            tag.m_128365_("data", (Tag)dataTag);
            NbtIo.m_128944_((CompoundTag)tag, (File)dataFile);
            VaultMod.LOGGER.info("Successfully force-saved VaultSpectatorData to file: " + dataFile.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            VaultMod.LOGGER.error("Failed to force save VaultSpectatorData", (Throwable)e);
            return false;
        }
    }

    public static boolean startSpectating(ServerPlayer player, UUID playerId) {
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return false;
        }
        if (playerId != null) {
            ServerPlayer targetPlayer = server.m_6846_().m_11259_(playerId);
            if (targetPlayer == null) {
                return false;
            }
            Optional<Vault> vaultOptional = ServerVaults.get((Level)targetPlayer.m_183503_());
            if (vaultOptional.isEmpty()) {
                VaultMod.LOGGER.info("No vault found for player: " + targetPlayer.m_7755_().getString());
                return false;
            }
            if (server.m_129900_().m_46207_(ModGameRules.SPECTATOR_PARTY_ONLY)) {
                Optional<VaultPartyData.Party> spectatorParty = VaultPartyData.get(server).getParty(player.m_142081_());
                Optional<VaultPartyData.Party> targetParty = VaultPartyData.get(server).getParty(targetPlayer.m_142081_());
                if (spectatorParty.isEmpty() || targetParty.isEmpty() || !spectatorParty.get().equals(targetParty.get())) {
                    return false;
                }
            }
            Vault vault = vaultOptional.get();
            VaultSpectatorData data = VaultSpectatorData.get(targetPlayer.m_183503_());
            if (data.addSpectator(vault.get(Vault.ID), player.m_142081_(), targetPlayer.m_142081_(), player.m_142538_())) {
                player.m_8999_(targetPlayer.m_183503_(), targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), targetPlayer.m_146908_(), targetPlayer.m_146909_());
                player.m_143403_(GameType.SPECTATOR);
                PlayerAbilitiesData.deactivateAllAbilities(player);
                if (((SpectatorMode.GameRuleValue)server.m_129900_().m_46170_(ModGameRules.SPECTATOR_MODE)).get() == SpectatorMode.PLAYER) {
                    player.m_9213_((Entity)targetPlayer);
                }
                ModNetwork.CHANNEL.sendTo((Object)new ClientboundSpectatorStatusMessage(true), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                return true;
            }
        }
        return false;
    }

    public static void stopSpectating(UUID spectatorId) {
        BlockPos originalPosition;
        Set<UUID> vaultSpectators;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        VaultSpectatorData data = VaultSpectatorData.get(server);
        if (server.m_6846_().m_11259_(spectatorId) == null) {
            return;
        }
        UUID vaultId = data.findVaultForSpectator(spectatorId);
        if (vaultId != null && (vaultSpectators = data.playersInSpectatorMode.get(vaultId)) != null) {
            vaultSpectators.remove(spectatorId);
            if (vaultSpectators.isEmpty()) {
                data.playersInSpectatorMode.remove(vaultId);
            }
        }
        VaultSpectatorData.returnPlayer(spectatorId, originalPosition, server, (originalPosition = data.spectatorPositions.get(spectatorId)) != null);
        ServerPlayer player = server.m_6846_().m_11259_(spectatorId);
        if (player != null) {
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundSpectatorStatusMessage(false), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
        data.removeFromTarget(spectatorId);
        data.m_77762_();
    }

    public static boolean changeSpectatorTarget(UUID spectatorId) {
        return VaultSpectatorData.changeSpectatorTarget(spectatorId, false);
    }

    public static boolean changeSpectatorTarget(UUID spectatorId, boolean logout) {
        UUID newTargetId;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return false;
        }
        VaultSpectatorData data = VaultSpectatorData.get(server);
        if (!data.isPlayerSpectating(spectatorId)) {
            VaultMod.LOGGER.info("Player is not spectating any vault: " + String.valueOf(spectatorId));
            return false;
        }
        UUID vaultId = data.findVaultForSpectator(spectatorId);
        if (vaultId == null) {
            VaultMod.LOGGER.info("No vault found for spectator: " + String.valueOf(spectatorId));
            VaultSpectatorData.stopSpectating(spectatorId);
            return false;
        }
        Vault vault = null;
        for (ServerLevel level : server.m_129785_()) {
            Optional<Vault> vaultOptional = ServerVaults.get((Level)level);
            if (!vaultOptional.isPresent() || !vaultOptional.get().get(Vault.ID).equals(vaultId)) continue;
            vault = vaultOptional.get();
            break;
        }
        if (vault == null) {
            VaultMod.LOGGER.info("Could not find active vault with ID: " + String.valueOf(vaultId));
            data.removeAllSpectatorsFromVault(vaultId);
            return false;
        }
        List<UUID> activeRunners = data.getActiveRunnersInVault(vaultId);
        if (activeRunners.isEmpty()) {
            VaultMod.LOGGER.info("No active runners found in vault: " + String.valueOf(vaultId));
            data.removeAllSpectatorsFromVault(vaultId);
            return false;
        }
        if (activeRunners.size() == 1 && activeRunners.get(0).equals(data.getSpectatingTarget(spectatorId))) {
            VaultMod.LOGGER.info("Only one active runner in vault, cannot change target: " + String.valueOf(vaultId));
            if (logout) {
                VaultMod.LOGGER.info("Stopping spectator due to logout: " + String.valueOf(spectatorId));
                VaultSpectatorData.stopSpectating(spectatorId);
            }
            return false;
        }
        UUID currentTargetId = data.getSpectatingTarget(spectatorId);
        if (currentTargetId == null || !activeRunners.contains(currentTargetId)) {
            newTargetId = activeRunners.get(0);
        } else {
            int currentIndex = activeRunners.indexOf(currentTargetId);
            int nextIndex = (currentIndex + 1) % activeRunners.size();
            newTargetId = activeRunners.get(nextIndex);
        }
        data.removeFromTarget(spectatorId);
        data.spectatorsTargets.computeIfAbsent(newTargetId, k -> new HashSet()).add(spectatorId);
        ServerPlayer spectator = server.m_6846_().m_11259_(spectatorId);
        ServerPlayer newTarget = server.m_6846_().m_11259_(newTargetId);
        if (spectator != null && newTarget != null) {
            spectator.m_8999_(newTarget.m_183503_(), newTarget.m_20185_(), newTarget.m_20186_(), newTarget.m_20189_(), newTarget.m_146908_(), newTarget.m_146909_());
            if (((SpectatorMode.GameRuleValue)server.m_129900_().m_46170_(ModGameRules.SPECTATOR_MODE)).get() == SpectatorMode.PLAYER) {
                VaultMod.LOGGER.info("Setting spectator camera to new target: " + newTarget.m_7755_().getString());
                spectator.m_9213_((Entity)newTarget);
            }
        }
        data.m_77762_();
        return true;
    }

    public List<UUID> getActiveRunnersInVault(UUID vaultId) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return new ArrayList<UUID>();
        }
        for (ServerLevel level : server.m_129785_()) {
            Optional<Vault> vaultOptional = ServerVaults.get((Level)level);
            if (!vaultOptional.isPresent() || !vaultOptional.get().get(Vault.ID).equals(vaultId)) continue;
            return vaultOptional.get().get(Vault.LISTENERS).getAll(Runner.class).stream().filter(runner -> runner.isOnline()).map(runner -> runner.get(Listener.ID)).toList();
        }
        return new ArrayList<UUID>();
    }

    public static VaultSpectatorData load(CompoundTag tag) {
        VaultSpectatorData data = new VaultSpectatorData();
        ListTag vaultSpectatorsListTag = tag.m_128437_("SpectatorMode", 10);
        for (int i = 0; i < vaultSpectatorsListTag.size(); ++i) {
            CompoundTag vaultSpectatorEntry = vaultSpectatorsListTag.m_128728_(i);
            UUID vaultId = UUID.fromString(vaultSpectatorEntry.m_128461_("VaultId"));
            HashSet<UUID> spectatorsInVault = new HashSet<UUID>();
            ListTag spectatorUuidsListTag = vaultSpectatorEntry.m_128437_("Spectators", 8);
            for (int j = 0; j < spectatorUuidsListTag.size(); ++j) {
                String spectatorUuidString = spectatorUuidsListTag.m_128778_(j);
                spectatorsInVault.add(UUID.fromString(spectatorUuidString));
            }
            data.playersInSpectatorMode.put(vaultId, spectatorsInVault);
        }
        ListTag spectatorPositionsListTag = tag.m_128437_("SpectatorPositions", 10);
        for (int i = 0; i < spectatorPositionsListTag.size(); ++i) {
            CompoundTag positionEntry = spectatorPositionsListTag.m_128728_(i);
            UUID playerId = UUID.fromString(positionEntry.m_128461_("PlayerId"));
            int x = positionEntry.m_128451_("X");
            int y = positionEntry.m_128451_("Y");
            int z = positionEntry.m_128451_("Z");
            BlockPos originalPosition = new BlockPos(x, y, z);
            data.spectatorPositions.put(playerId, originalPosition);
        }
        ListTag spectatorTargetsListTag = tag.m_128437_("SpectatorTargets", 10);
        for (int i = 0; i < spectatorTargetsListTag.size(); ++i) {
            CompoundTag targetEntry = spectatorTargetsListTag.m_128728_(i);
            UUID runnerId = UUID.fromString(targetEntry.m_128461_("RunnerId"));
            HashSet<UUID> spectatorsWatchingRunner = new HashSet<UUID>();
            ListTag watcherUuidsListTag = targetEntry.m_128437_("SpectatorList", 8);
            for (int j = 0; j < watcherUuidsListTag.size(); ++j) {
                String spectatorUuidString = watcherUuidsListTag.m_128778_(j);
                spectatorsWatchingRunner.add(UUID.fromString(spectatorUuidString));
            }
            data.spectatorsTargets.put(runnerId, spectatorsWatchingRunner);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag vaultSpectatorsListTag = new ListTag();
        for (Map.Entry<UUID, Set<UUID>> entry : this.playersInSpectatorMode.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("VaultId", entry.getKey().toString());
            ListTag spectatorUuidsListTag = new ListTag();
            for (UUID spectatorId : entry.getValue()) {
                spectatorUuidsListTag.add((Object)StringTag.m_129297_((String)spectatorId.toString()));
            }
            compoundTag.m_128365_("Spectators", (Tag)spectatorUuidsListTag);
            vaultSpectatorsListTag.add((Object)compoundTag);
        }
        tag.m_128365_("SpectatorMode", (Tag)vaultSpectatorsListTag);
        ListTag spectatorPositionsListTag = new ListTag();
        for (Map.Entry<UUID, BlockPos> entry : this.spectatorPositions.entrySet()) {
            CompoundTag positionData = new CompoundTag();
            positionData.m_128359_("PlayerId", entry.getKey().toString());
            BlockPos originalPosition = entry.getValue();
            positionData.m_128405_("X", originalPosition.m_123341_());
            positionData.m_128405_("Y", originalPosition.m_123342_());
            positionData.m_128405_("Z", originalPosition.m_123343_());
            spectatorPositionsListTag.add((Object)positionData);
        }
        tag.m_128365_("SpectatorPositions", (Tag)spectatorPositionsListTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, Set<UUID>> targetEntry : this.spectatorsTargets.entrySet()) {
            CompoundTag runnerSpectatorData = new CompoundTag();
            runnerSpectatorData.m_128359_("RunnerId", targetEntry.getKey().toString());
            ListTag watcherUuidsListTag = new ListTag();
            for (UUID spectatorId : targetEntry.getValue()) {
                watcherUuidsListTag.add((Object)StringTag.m_129297_((String)spectatorId.toString()));
            }
            runnerSpectatorData.m_128365_("SpectatorList", (Tag)watcherUuidsListTag);
            listTag.add((Object)runnerSpectatorData);
        }
        tag.m_128365_("SpectatorTargets", (Tag)listTag);
        return tag;
    }

    public UUID findVaultForSpectator(UUID spectatorUUID) {
        for (Map.Entry<UUID, Set<UUID>> entry : this.playersInSpectatorMode.entrySet()) {
            if (!entry.getValue().contains(spectatorUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isPlayerSpectating(UUID playerUUID) {
        return this.spectatorPositions.get(playerUUID) != null;
    }

    public UUID getSpectatingTarget(UUID spectatorUUID) {
        for (Map.Entry<UUID, Set<UUID>> entry : this.spectatorsTargets.entrySet()) {
            if (!entry.getValue().contains(spectatorUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void removeFromTarget(UUID spectatorId) {
        Set<UUID> currentTargetSpectators;
        UUID currentTargetId = this.getSpectatingTarget(spectatorId);
        if (currentTargetId != null && (currentTargetSpectators = this.spectatorsTargets.get(currentTargetId)) != null) {
            currentTargetSpectators.remove(spectatorId);
            if (currentTargetSpectators.isEmpty()) {
                this.spectatorsTargets.remove(currentTargetId);
            }
        }
    }

    public Set<UUID> getSpectatorsWatchingPlayer(UUID targetUUID) {
        return this.spectatorsTargets.getOrDefault(targetUUID, new HashSet());
    }

    public boolean addSpectator(UUID vaultId, UUID spectatorId, UUID targetId, BlockPos originalPos) {
        if (this.isPlayerSpectating(spectatorId)) {
            return false;
        }
        this.playersInSpectatorMode.computeIfAbsent(vaultId, k -> new HashSet()).add(spectatorId);
        this.spectatorPositions.put(spectatorId, originalPos);
        this.spectatorsTargets.computeIfAbsent(targetId, k -> new HashSet()).add(spectatorId);
        this.m_77762_();
        return true;
    }

    public int removeAllSpectatorsFromVault(UUID vaultId) {
        Set<UUID> spectatorsInVault = this.playersInSpectatorMode.get(vaultId);
        if (spectatorsInVault == null || spectatorsInVault.isEmpty()) {
            return 0;
        }
        int removedCount = spectatorsInVault.size();
        for (UUID spectatorId : spectatorsInVault) {
            BlockPos originalPosition = this.spectatorPositions.get(spectatorId);
            if (originalPosition != null) {
                MinecraftServer server;
                VaultSpectatorData.returnPlayer(spectatorId, originalPosition, server, (server = ServerLifecycleHooks.getCurrentServer()) != null);
            }
            this.playersInSpectatorMode.remove(vaultId);
            this.removeFromTarget(spectatorId);
        }
        this.m_77762_();
        return removedCount;
    }

    private static void returnPlayer(UUID spectatorId, BlockPos originalPosition, MinecraftServer server, boolean b) {
        ServerPlayer player;
        if (b && (player = server.m_6846_().m_11259_(spectatorId)) != null) {
            player.m_8999_(server.m_129783_(), (double)originalPosition.m_123341_(), (double)originalPosition.m_123342_(), (double)originalPosition.m_123343_(), player.m_146908_(), player.m_146909_());
            player.m_143403_(GameType.SURVIVAL);
            player.m_9213_((Entity)player);
            VaultSpectatorData.get((MinecraftServer)server).spectatorPositions.remove(spectatorId);
        }
    }
}

