/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.core.world.threading.ThreadPool;
import iskallia.vault.core.world.threading.ThreadingMode;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.mixin.AccessorMinecraftServer;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.network.message.WorldListUpdateMessage;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VirtualWorlds
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VirtualWorlds";
    protected static ThreadPool CONCURRENT_POOL = new ThreadPool(Runtime.getRuntime().availableProcessors());
    protected static Queue<Runnable> SCHEDULED_TASKS = new ConcurrentLinkedQueue<Runnable>();
    protected static AtomicReference<ReportedException> CRASH = new AtomicReference();
    private VListNBT<VirtualWorld, CompoundTag> entries = new VListNBT<VirtualWorld, CompoundTag>(world -> {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("id", world.m_46472_().m_135782_().toString());
        nbt.m_128405_("mode", world.getThreadingMode().ordinal());
        nbt.m_128379_("delete", world.isMarkedForDeletion());
        return nbt;
    }, nbt -> {
        VirtualWorld world = VirtualWorld.create(new ResourceLocation(nbt.m_128461_("id")), ThreadingMode.values()[nbt.m_128451_("mode")]);
        if (nbt.m_128471_("delete")) {
            world.markForDeletion();
        }
        return world;
    });

    protected VirtualWorlds(CompoundTag nbt2) {
        this.load(nbt2);
    }

    protected VirtualWorlds() {
    }

    public boolean m_77764_() {
        return true;
    }

    public static List<VirtualWorld> getAll() {
        return VirtualWorlds.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).entries;
    }

    private static VirtualWorld load(VirtualWorld world) {
        MinecraftServer server = world.m_142572_();
        ((AccessorMinecraftServer)server).getWorldsMap().put((ResourceKey<Level>)world.m_46472_(), world);
        server.m_129783_().m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(world.m_6857_()));
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)world));
        return world;
    }

    private static VirtualWorld unload(VirtualWorld world) {
        MinecraftServer server = world.m_142572_();
        ((AccessorMinecraftServer)server).getWorldsMap().remove(world.m_46472_());
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((LevelAccessor)world));
        try {
            world.close();
        }
        catch (IOException e) {
            VaultMod.LOGGER.error("Failed to close virtual world {}", (Object)world.m_46472_(), (Object)e);
        }
        return world;
    }

    public static VirtualWorld register(VirtualWorld world) {
        VirtualWorlds.load(world);
        world.m_142572_().markWorldsDirty();
        world.m_142572_().m_6846_().m_11314_().forEach(player -> {
            List<ResourceLocation> ids = ((AccessorMinecraftServer)world.m_142572_()).getWorldsMap().keySet().stream().map(ResourceKey::m_135782_).collect(Collectors.toList());
            ModNetwork.CHANNEL.sendTo((Object)new WorldListUpdateMessage(ids), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        });
        VirtualWorlds.get((MinecraftServer)world.m_142572_()).entries.add(world);
        return world;
    }

    public static VirtualWorld deregister(VirtualWorld world) {
        VirtualWorlds.unload(world);
        world.m_142572_().markWorldsDirty();
        world.m_142572_().m_6846_().m_11314_().forEach(player -> {
            List<ResourceLocation> ids = ((AccessorMinecraftServer)world.m_142572_()).getWorldsMap().keySet().stream().map(ResourceKey::m_135782_).collect(Collectors.toList());
            ModNetwork.CHANNEL.sendTo((Object)new WorldListUpdateMessage(ids), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        });
        VirtualWorlds.get((MinecraftServer)world.m_142572_()).entries.remove((Object)world);
        return world;
    }

    public static void tick(BooleanSupplier hasTimeLeft, TickEvent.Phase phase) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        switch (phase) {
            case START: {
                VirtualWorlds.tickDeletions(server, hasTimeLeft);
                for (Level anyWorld : server.m_129785_()) {
                    if (!(anyWorld instanceof VirtualWorld)) continue;
                    VirtualWorld world = (VirtualWorld)anyWorld;
                    switch (world.getThreadingMode()) {
                        case CONCURRENT: {
                            CONCURRENT_POOL.execute(() -> world.swapThreadsAndRun(Thread.currentThread(), () -> VirtualWorlds.tickWorldSafe(server, world, hasTimeLeft, true, CRASH)));
                            break;
                        }
                        case PARALLEL: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
                break;
            }
            case END: {
                Runnable task;
                for (Level anyWorld : server.m_129785_()) {
                    VirtualWorld world;
                    if (!(anyWorld instanceof VirtualWorld) || (world = (VirtualWorld)anyWorld).getThreadingMode() != ThreadingMode.SEQUENTIAL) continue;
                    VirtualWorlds.tickWorldSafe(server, world, hasTimeLeft, false, CRASH);
                }
                CONCURRENT_POOL.awaitCompletion();
                if (CRASH.get() != null) {
                    SCHEDULED_TASKS.clear();
                    ReportedException value = CRASH.get();
                    CRASH.set(null);
                    throw value;
                }
                while ((task = SCHEDULED_TASKS.poll()) != null) {
                    task.run();
                }
                break;
            }
        }
    }

    private static void tickDeletions(MinecraftServer server, BooleanSupplier hasTimeLeft) {
        LevelStorageSource.LevelStorageAccess session = ((AccessorMinecraftServer)server).getSession();
        for (VirtualWorld world : new ArrayList(VirtualWorlds.get((MinecraftServer)server).entries)) {
            if (!world.isMarkedForDeletion()) continue;
            VirtualWorlds.deregister(world);
            final Path folder = session.m_197394_(world.m_46472_());
            VaultMod.LOGGER.info("Deleting level {}", (Object)folder);
            try {
                Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                        VaultMod.LOGGER.debug("Deleting {}", (Object)path);
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path path, IOException exception) throws IOException {
                        if (exception != null) {
                            throw exception;
                        }
                        if (path.equals(folder)) {
                            Files.deleteIfExists(path);
                        }
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {}
            break;
        }
    }

    private static void tickWorldSafe(MinecraftServer server, VirtualWorld world, BooleanSupplier hasTimeLeft, boolean deferEvents, AtomicReference<ReportedException> crash) {
        try {
            VirtualWorlds.tickWorld(server, world, hasTimeLeft, deferEvents);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Exception ticking world");
            world.m_6026_(crashreport);
            crash.set(new ReportedException(crashreport));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tickWorld(MinecraftServer server, VirtualWorld world, BooleanSupplier hasTimeLeft, boolean deferEvents) {
        long tickStart = Util.m_137569_();
        VirtualWorld virtualWorld = world;
        synchronized (virtualWorld) {
            if (!deferEvents) {
                ForgeEventFactory.onPreWorldTick((Level)world, (BooleanSupplier)hasTimeLeft);
            } else {
                SCHEDULED_TASKS.add(() -> ForgeEventFactory.onPreWorldTick((Level)world, (BooleanSupplier)hasTimeLeft));
            }
            world.m_8793_(hasTimeLeft);
            if (!deferEvents) {
                ForgeEventFactory.onPostWorldTick((Level)world, (BooleanSupplier)hasTimeLeft);
            } else {
                SCHEDULED_TASKS.add(() -> ForgeEventFactory.onPostWorldTick((Level)world, (BooleanSupplier)hasTimeLeft));
            }
        }
        ((AccessorMinecraftServer)server).getPerWorldTickTimes().computeIfAbsent((ResourceKey<Level>)world.m_46472_(), (Function<ResourceKey, long[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$tickWorld$8(net.minecraft.resources.ResourceKey ), (Lnet/minecraft/resources/ResourceKey;)[J)())[world.getTickCount() % 100] = Util.m_137569_() - tickStart;
    }

    public static void load() {
        VirtualWorlds.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).entries.forEach(VirtualWorlds::load);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("entries", (Tag)this.entries.serializeNBT());
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.entries.deserializeNBT(nbt.m_128437_("entries", 10));
    }

    private static VirtualWorlds get(MinecraftServer server) {
        return (VirtualWorlds)server.m_129783_().m_8895_().m_164861_(VirtualWorlds::new, VirtualWorlds::new, DATA_NAME);
    }

    private static /* synthetic */ long[] lambda$tickWorld$8(ResourceKey k) {
        return new long[100];
    }
}

