/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class VoidStoneBlacklistData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultVoidStoneBlacklistData";
    private final HashMap<UUID, BlacklistInventory> blacklistedItems = new HashMap();

    public BlacklistInventory getInventory(ServerPlayer player) {
        if (this.blacklistedItems.containsKey(player.m_142081_())) {
            return this.blacklistedItems.get(player.m_142081_());
        }
        BlacklistInventory inventory = new BlacklistInventory();
        this.blacklistedItems.put(player.m_142081_(), inventory);
        this.m_77762_();
        return inventory;
    }

    public void updateBlacklist(ServerPlayer player, List<ResourceLocation> blacklist) {
        BlacklistInventory inventory = this.getInventory(player);
        inventory.updateBlacklist(blacklist);
        this.m_77762_();
    }

    public void toggleBlacklist(ServerPlayer player, ResourceLocation blacklist) {
        BlacklistInventory inventory = this.getInventory(player);
        if (inventory.blacklist.contains(blacklist)) {
            inventory.blacklist.remove(blacklist);
        } else {
            inventory.blacklist.add(blacklist);
        }
        this.m_77762_();
    }

    public void addBlacklist(ServerPlayer player, ResourceLocation blacklist) {
        BlacklistInventory inventory = this.getInventory(player);
        if (inventory.blacklist.contains(blacklist)) {
            return;
        }
        inventory.blacklist.add(blacklist);
        this.m_77762_();
    }

    public void removeBlacklist(ServerPlayer player, ResourceLocation blacklist) {
        BlacklistInventory inventory = this.getInventory(player);
        inventory.blacklist.remove(blacklist);
        this.m_77762_();
    }

    private static VoidStoneBlacklistData create(CompoundTag tag) {
        VoidStoneBlacklistData data = new VoidStoneBlacklistData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            UUID playerId;
            try {
                playerId = UUID.fromString(key);
            }
            catch (IllegalArgumentException exception) {
                continue;
            }
            CompoundTag inventoryNbt = nbt.m_128469_(key);
            BlacklistInventory inventory = new BlacklistInventory();
            inventory.deserializeNBT(inventoryNbt);
            this.blacklistedItems.put(playerId, inventory);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        this.blacklistedItems.forEach((uuid, inventory) -> compound.m_128365_(uuid.toString(), (Tag)inventory.serializeNBT()));
        return compound;
    }

    public static VoidStoneBlacklistData get(ServerLevel world) {
        return (VoidStoneBlacklistData)world.m_142572_().m_129783_().m_8895_().m_164861_(VoidStoneBlacklistData::create, VoidStoneBlacklistData::new, DATA_NAME);
    }

    public static class BlacklistInventory
    implements INBTSerializable<CompoundTag> {
        private List<ResourceLocation> blacklist = new ArrayList<ResourceLocation>();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag listTag = new ListTag();
            this.blacklist.forEach(resourceLocation -> listTag.add((Object)StringTag.m_129297_((String)resourceLocation.toString())));
            tag.m_128365_("Blacklist", (Tag)listTag);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (nbt == null) {
                return;
            }
            if (!nbt.m_128425_("Blacklist", 9)) {
                return;
            }
            ListTag listTag = nbt.m_128437_("Blacklist", 8);
            this.blacklist.clear();
            if (this.blacklist == null) {
                this.blacklist = new ArrayList<ResourceLocation>();
            }
            listTag.forEach(tag -> {
                ResourceLocation rl = new ResourceLocation(tag.m_7916_());
                this.blacklist.add(rl);
            });
        }

        private void updateBlacklist(List<ResourceLocation> blacklist) {
            this.blacklist = blacklist;
        }

        public boolean isBlacklisted(ResourceLocation resourceLocation) {
            return this.blacklist.contains(resourceLocation);
        }

        public List<ResourceLocation> getBlacklist() {
            return this.blacklist;
        }

        public static BlacklistInventory fromNbt(CompoundTag nbt) {
            BlacklistInventory inventory = new BlacklistInventory();
            inventory.deserializeNBT(nbt);
            return inventory;
        }
    }
}

