/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundUpdateDifficultyMessage;
import iskallia.vault.world.VaultDifficulty;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class WorldSettings
extends SavedData {
    protected static final String DATA_NAME = "the_vault_WorldSettings";
    private static final String PLAYER_DIFFICULTIES_TAG = "playerDifficulties";
    private final Map<UUID, VaultDifficulty> playerDifficulties = new HashMap<UUID, VaultDifficulty>();
    private static final WorldSettings clientSettings = new WorldSettings();
    private VaultDifficulty vaultDifficulty = VaultDifficulty.NORMAL;
    private boolean vaultDifficultyLocked = false;

    @SubscribeEvent
    public static void syncOnLogin(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            return;
        }
        WorldSettings worldSettings = WorldSettings.get((Level)player.m_183503_());
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundUpdateDifficultyMessage(worldSettings.getGlobalVaultDifficulty(), worldSettings.isVaultDifficultyLocked()));
    }

    private static WorldSettings create(CompoundTag tag) {
        WorldSettings data = new WorldSettings();
        data.load(tag);
        return data;
    }

    public static WorldSettings get(@Nullable Level level) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (WorldSettings)serverLevel.m_142572_().m_129783_().m_8895_().m_164861_(WorldSettings::create, WorldSettings::new, DATA_NAME);
        }
        return clientSettings;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("vaultDifficulty", this.vaultDifficulty.getId());
        tag.m_128379_("vaultDifficultyLocked", this.vaultDifficultyLocked);
        tag.m_128365_(PLAYER_DIFFICULTIES_TAG, (Tag)this.serializePlayerDifficulties());
        return tag;
    }

    private CompoundTag serializePlayerDifficulties() {
        CompoundTag tag = new CompoundTag();
        this.playerDifficulties.forEach((playerId, difficulty) -> tag.m_128405_(playerId.toString(), difficulty.getId()));
        return tag;
    }

    private void load(CompoundTag tag) {
        this.vaultDifficulty = VaultDifficulty.byId(tag.m_128451_("vaultDifficulty"));
        this.vaultDifficultyLocked = tag.m_128471_("vaultDifficultyLocked");
        this.playerDifficulties.clear();
        if (tag.m_128441_(PLAYER_DIFFICULTIES_TAG)) {
            CompoundTag difficultiesTag = tag.m_128469_(PLAYER_DIFFICULTIES_TAG);
            difficultiesTag.m_128431_().forEach(playerId -> this.playerDifficulties.put(UUID.fromString(playerId), VaultDifficulty.byId(difficultiesTag.m_128451_(playerId))));
        }
    }

    public VaultDifficulty getPlayerDifficulty(UUID playerId) {
        return this.playerDifficulties.getOrDefault(playerId, this.vaultDifficulty);
    }

    public VaultDifficulty getGlobalVaultDifficulty() {
        return this.vaultDifficulty;
    }

    public void setGlobalVaultDifficulty(VaultDifficulty vaultDifficulty) {
        this.vaultDifficulty = vaultDifficulty;
        this.m_77762_();
    }

    public boolean isVaultDifficultyLocked() {
        return this.vaultDifficultyLocked;
    }

    public void setVaultDifficultyLocked(boolean vaultDifficultyLocked) {
        this.vaultDifficultyLocked = vaultDifficultyLocked;
        this.m_77762_();
    }

    public void setPlayerDifficulty(UUID playerId, VaultDifficulty difficulty) {
        this.playerDifficulties.put(playerId, difficulty);
        this.m_77762_();
    }
}

