/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.storage.WorldZones;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.UpdateWorldZonesDataMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldZonesData
extends SavedData {
    public static WorldZonesData CLIENT = new WorldZonesData();
    protected static final String DATA_NAME = "the_vault_Zones";
    private final Map<ResourceKey<Level>, WorldZones> zones = new HashMap<ResourceKey<Level>, WorldZones>();
    private boolean cleared = false;
    private final Set<ResourceKey<Level>> addedDimensions = new HashSet<ResourceKey<Level>>();
    private final Set<ResourceKey<Level>> removedDimensions = new HashSet<ResourceKey<Level>>();

    public Map<ResourceKey<Level>, WorldZones> getZones() {
        return this.zones;
    }

    public boolean isCleared() {
        return this.cleared;
    }

    public Set<ResourceKey<Level>> getAddedDimensions() {
        return this.addedDimensions;
    }

    public Set<ResourceKey<Level>> getRemovedDimensions() {
        return this.removedDimensions;
    }

    public void clear() {
        this.zones.clear();
        this.cleared = true;
        this.addedDimensions.clear();
        this.removedDimensions.clear();
    }

    public WorldZones getOrCreate(ResourceKey<Level> dimension) {
        WorldZones zones = this.zones.get(dimension);
        if (zones != null) {
            return zones;
        }
        zones = new WorldZones();
        this.zones.put(dimension, zones);
        this.addedDimensions.add(dimension);
        return zones;
    }

    public void remove(ResourceKey<Level> dimension) {
        this.zones.remove(dimension);
        this.addedDimensions.remove(dimension);
        this.removedDimensions.add(dimension);
    }

    public void refreshDiff() {
        this.cleared = false;
        this.addedDimensions.clear();
        this.removedDimensions.clear();
        for (WorldZones zones : this.zones.values()) {
            zones.refreshDiff();
        }
    }

    public boolean m_77764_() {
        return true;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.zones.forEach((dimension, zones) -> {
            CompoundTag entry = new CompoundTag();
            Adapters.DIMENSION.writeNbt((ResourceKey<Level>)dimension).ifPresent(tag -> entry.m_128365_("dimension", tag));
            Adapters.WORLD_ZONES.writeNbt((WorldZones)zones).ifPresent(tag -> entry.m_128365_("zones", tag));
            list.add((Object)entry);
        });
        nbt.m_128365_("zones", (Tag)list);
        return nbt;
    }

    public void load(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("zones", 10);
        this.zones.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entry = list.m_128728_(i);
            this.zones.put(Adapters.DIMENSION.readNbt(entry.m_128423_("dimension")).orElseThrow(), Adapters.WORLD_ZONES.readNbt(entry.m_128423_("zones")).orElseThrow());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldZonesData data = WorldZonesData.get(player2.m_20194_());
            ModNetwork.CHANNEL.sendTo((Object)UpdateWorldZonesDataMessage.full(data), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        WorldZonesData data = WorldZonesData.get(ServerLifecycleHooks.getCurrentServer());
        UpdateWorldZonesDataMessage packet = UpdateWorldZonesDataMessage.diff(data);
        if (!packet.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)packet);
            data.refreshDiff();
        }
    }

    public static WorldZonesData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return WorldZonesData.get(serverWorld.m_142572_());
        }
        return CLIENT;
    }

    public static WorldZonesData get(MinecraftServer server) {
        return (WorldZonesData)server.m_129783_().m_8895_().m_164861_(nbt -> {
            WorldZonesData data = new WorldZonesData();
            data.load((CompoundTag)nbt);
            return data;
        }, WorldZonesData::new, DATA_NAME);
    }
}

