/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.structure.pool;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import iskallia.vault.init.ModStructures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PalettedSinglePoolElement
extends StructurePoolElement {
    private static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(PalettedSinglePoolElement::encodeTemplate, (Decoder)ResourceLocation.f_135803_.map(Either::left));
    public static final Codec<PalettedSinglePoolElement> CODEC = RecordCodecBuilder.create(p_236841_0_ -> p_236841_0_.group(PalettedSinglePoolElement.templateCodec(), PalettedSinglePoolElement.processorsCodec(), (App)PalettedSinglePoolElement.m_210538_()).apply((Applicative)p_236841_0_, PalettedSinglePoolElement::new));
    protected final Either<ResourceLocation, StructureTemplate> template;
    protected final Holder<StructureProcessorList> processors;

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> p_236840_0_, DynamicOps<T> p_236840_1_, T p_236840_2_) {
        Optional optional = p_236840_0_.left();
        return !optional.isPresent() ? DataResult.error((String)"Can not serialize a runtime pool element") : ResourceLocation.f_135803_.encode((Object)((ResourceLocation)optional.get()), p_236840_1_, p_236840_2_);
    }

    protected static <E extends PalettedSinglePoolElement> RecordCodecBuilder<E, Holder<StructureProcessorList>> processorsCodec() {
        return StructureProcessorType.f_74468_.fieldOf("processors").forGetter(p_236845_0_ -> p_236845_0_.processors);
    }

    protected static <E extends PalettedSinglePoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(p_236842_0_ -> p_236842_0_.template);
    }

    protected PalettedSinglePoolElement(Either<ResourceLocation, StructureTemplate> p_i242008_1_, Holder<StructureProcessorList> p_i242008_2_, StructureTemplatePool.Projection p_i242008_3_) {
        super(p_i242008_3_);
        this.template = p_i242008_1_;
        this.processors = p_i242008_2_;
    }

    public PalettedSinglePoolElement(StructureTemplate p_210419_) {
        this((Either<ResourceLocation, StructureTemplate>)Either.right((Object)p_210419_), (Holder<StructureProcessorList>)ProcessorLists.f_127198_, StructureTemplatePool.Projection.RIGID);
    }

    public Either<ResourceLocation, StructureTemplate> getTemplate() {
        return this.template;
    }

    public StructureTemplate getTemplate(StructureManager manager) {
        return (StructureTemplate)this.template.map(arg_0 -> ((StructureManager)manager).m_74341_(arg_0), Function.identity());
    }

    public List<StructureTemplate.StructureBlockInfo> getDataMarkers(StructureManager p_214857_1_, BlockPos p_214857_2_, Rotation p_214857_3_, boolean p_214857_4_) {
        StructureTemplate template = this.getTemplate(p_214857_1_);
        List list = template.m_74607_(p_214857_2_, new StructurePlaceSettings().m_74379_(p_214857_3_), Blocks.f_50677_, p_214857_4_);
        ArrayList list1 = Lists.newArrayList();
        for (StructureTemplate.StructureBlockInfo template$blockinfo : list) {
            StructureMode structuremode;
            if (template$blockinfo.f_74677_ == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.f_74677_.m_128461_("mode"))) != StructureMode.DATA) continue;
            list1.add(template$blockinfo);
        }
        return list1;
    }

    public Vec3i m_207466_(StructureManager p_210493_, Rotation p_210494_) {
        StructureTemplate structuretemplate = this.getTemplate(p_210493_);
        return structuretemplate.m_163808_(p_210494_);
    }

    public List<StructureTemplate.StructureBlockInfo> m_207245_(StructureManager templateManager, BlockPos pos, Rotation rotation, Random random) {
        StructureTemplate template = this.getTemplate(templateManager);
        List list = template.m_74607_(pos, new StructurePlaceSettings().m_74379_(rotation), Blocks.f_50678_, true);
        Collections.shuffle(list, random);
        return list;
    }

    public BoundingBox m_207470_(StructureManager templateManager, BlockPos pos, Rotation rotation) {
        StructureTemplate template = this.getTemplate(templateManager);
        return template.m_74633_(new StructurePlaceSettings().m_74379_(rotation), pos);
    }

    public boolean m_207251_(StructureManager templateManager, WorldGenLevel world, StructureFeatureManager structureManager, ChunkGenerator chunkGen, BlockPos pos1, BlockPos pos2, Rotation rotation, BoundingBox box, Random random, boolean keepJigsaws) {
        return this.generate(null, templateManager, world, structureManager, chunkGen, pos1, pos2, rotation, box, random, keepJigsaws, 18);
    }

    public boolean generate(@Nullable Supplier<StructureProcessorList> extra, StructureManager templateManager, WorldGenLevel world, StructureFeatureManager structureManager, ChunkGenerator chunkGen, BlockPos pos1, BlockPos pos2, Rotation rotation, BoundingBox box, Random random, boolean keepJigsaws, int updateFlags) {
        StructurePlaceSettings placementsettings;
        StructureTemplate template = this.getTemplate(templateManager);
        if (!template.m_74536_((ServerLevelAccessor)world, pos1, pos2, placementsettings = this.getSettings(extra, rotation, box, keepJigsaws), random, updateFlags)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo info : StructureTemplate.processBlockInfos((LevelAccessor)world, (BlockPos)pos1, (BlockPos)pos2, (StructurePlaceSettings)placementsettings, this.getDataMarkers(templateManager, pos1, rotation, false), (StructureTemplate)template)) {
            this.m_210472_((LevelAccessor)world, info, pos1, rotation, random, box);
        }
        return true;
    }

    protected StructurePlaceSettings getSettings(@Nullable Supplier<StructureProcessorList> extra, Rotation p_230379_1_, BoundingBox p_230379_2_, boolean p_230379_3_) {
        StructurePlaceSettings placementsettings = new StructurePlaceSettings();
        placementsettings.m_74381_(p_230379_2_);
        placementsettings.m_74379_(p_230379_1_);
        placementsettings.m_74402_(true);
        placementsettings.m_74392_(false);
        placementsettings.m_74405_(true);
        if (!p_230379_3_) {
            placementsettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.processors.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
        if (extra != null) {
            extra.get().m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
        }
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
        return placementsettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return ModStructures.PoolElements.PALETTED_SINGLE_POOL_ELEMENT;
    }

    public String toString() {
        return "PalettedSingle[" + String.valueOf(this.template) + "]";
    }
}

