/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.chest;

import com.google.gson.annotations.Expose;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.world.vault.chest.VaultChestEffect;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PotionCloudEffect
extends VaultChestEffect {
    @Expose
    public List<String> potions;

    public PotionCloudEffect(String name, Potion ... potions) {
        super(name);
        this.potions = Arrays.stream(potions).map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public List<Potion> getPotions() {
        return this.potions.stream().map(s -> Registry.f_122828_.m_6612_(new ResourceLocation(s)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void apply(VirtualWorld world, Vault vault, ServerPlayer player) {
        ThrownPotion entity = new ThrownPotion((Level)world, (LivingEntity)player);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42739_);
        this.getPotions().forEach(potion -> PotionUtils.m_43549_((ItemStack)stack, (Potion)potion));
        entity.m_37446_(stack);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
        world.m_7967_((Entity)entity);
    }
}

