/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.www;

import iskallia.vault.util.IskalliaDevs;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public class Reward {
    private UUID id;
    private Map<String, List<String>> rewards;

    public Reward(String id, Map<String, List<String>> rewards) {
        this.id = UUID.fromString(id);
        this.rewards = rewards;
    }

    public Reward(UUID id, Map<String, List<String>> rewards) {
        this.id = id;
        this.rewards = rewards;
    }

    public UUID getId() {
        return this.id;
    }

    public Map<String, List<String>> getRewards() {
        return this.rewards;
    }

    public boolean hasModel(ArmorPiece armor, ResourceLocation id) {
        if (IskalliaDevs.isDeveloper(this.id)) {
            return true;
        }
        for (String itemId : armor.getItemIds()) {
            if (!this.rewards.containsKey(itemId)) continue;
            for (String rewardId : this.rewards.get(itemId)) {
                if (!rewardId.contains(id.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static enum ArmorPiece {
        ALL("the_vault:helmet", "the_vault:chestplate", "the_vault:leggings", "the_vault:boots", "the_vault:sword", "the_vault:axe", "the_vault:wand", "the_vault:focus", "the_vault:shield", "the_vault:magnet"),
        ARMOR("the_vault:helmet", "the_vault:chestplate", "the_vault:leggings", "the_vault:boots"),
        HELMET("the_vault:helmet"),
        CHESTPLATE("the_vault:chestplate"),
        LEGGINGS("the_vault:leggings"),
        BOOTS("the_vault:boots"),
        SWORD("the_vault:sword"),
        AXE("the_vault:axe"),
        WAND("the_vault:wand"),
        FOCUS("the_vault:focus"),
        SHIELD("the_vault:shield"),
        MAGNET("the_vault:magnet"),
        COMPANION("the_vault:companion");

        private final String[] itemIds;

        private ArmorPiece(String ... itemIds) {
            this.itemIds = itemIds;
        }

        public String[] getItemIds() {
            return this.itemIds;
        }

        public boolean matches(String id) {
            for (String itemId : this.itemIds) {
                if (!itemId.equals(id)) continue;
                return true;
            }
            return false;
        }
    }
}

