/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.www;

import com.google.gson.Gson;
import iskallia.vault.VaultMod;
import iskallia.vault.www.Reward;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class RewardsManager {
    private static final RewardsManager INSTANCE = new RewardsManager();
    private static final String DEMO_URL_BASE = "https://rewards.vaulthunters.gg/";
    private static final String PROD_URL_BASE = "https://rewards.vaulthunters.gg/";
    private static final Gson GSON = new Gson();
    private final List<Reward> cachedRewards = new ArrayList<Reward>();

    public static RewardsManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cachedRewards.clear();
    }

    public void clearCache(UUID uuid) {
        this.cachedRewards.removeIf(reward -> reward.getId().equals(uuid));
    }

    public Reward getRewardData(UUID playerId) {
        return this.getRewards(playerId);
    }

    private synchronized Reward getRewards(UUID playerId) {
        Reward existingCached = this.cachedRewards.stream().filter(existing -> existing.getId().equals(playerId)).findFirst().orElse(null);
        if (existingCached != null) {
            return existingCached;
        }
        this.cachedRewards.add(new Reward(playerId, new HashMap<String, List<String>>()));
        this.requestRewards(playerId, loadedTiers -> {
            this.cachedRewards.removeIf(reward -> reward.getId().equals(playerId));
            this.cachedRewards.add(Objects.requireNonNullElseGet(loadedTiers, () -> new Reward(playerId, new HashMap<String, List<String>>())));
        });
        return new Reward(playerId, new HashMap<String, List<String>>());
    }

    private void requestRewards(UUID playerId, Consumer<Reward> onLoad) {
        Thread tr = new Thread(() -> {
            try {
                HttpURLConnection connection = RewardsManager.getHttpURLConnection(playerId);
                if (connection.getResponseCode() != 200) {
                    VaultMod.LOGGER.error("Fetching Player Rewards failed! Response code: {}", (Object)connection.getResponseCode());
                    onLoad.accept(null);
                    return;
                }
                String response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                onLoad.accept((Reward)GSON.fromJson(response, Reward.class));
            }
            catch (Exception e) {
                VaultMod.LOGGER.error("Fetching Player rewards failed!", (Throwable)e);
                onLoad.accept(null);
            }
        }, "Player Rewards Request - " + playerId.toString());
        tr.setDaemon(true);
        tr.start();
    }

    @NotNull
    private static HttpURLConnection getHttpURLConnection(UUID playerId) throws IOException {
        String urlPart = FMLEnvironment.production ? "https://rewards.vaulthunters.gg/" : "https://rewards.vaulthunters.gg/";
        URL url = new URL(urlPart + "rewards?minecraft=" + playerId.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.connect();
        return connection;
    }
}

