/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.www.auth;

import com.google.gson.Gson;
import iskallia.vault.VaultMod;
import iskallia.vault.www.patreon.PatreonTier;
import iskallia.vault.www.patreon.RewardResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class AuthenticationManager {
    private static final AuthenticationManager INSTANCE = new AuthenticationManager();
    private static final String CLIENT_START_URL = "https://rewards.vaulthunters.gg/pre-release/client_start";
    private static final String PATREON_REWARD_URL = "https://api.vaulthunters.gg/users/reward?uuid=";
    private static final Gson GSON = new Gson();
    private volatile boolean champion;

    private AuthenticationManager() {
    }

    public static AuthenticationManager getInstance() {
        return INSTANCE;
    }

    public boolean isChampion() {
        return this.champion;
    }

    public void authenticate(UUID playerId) {
        if (playerId == null) {
            return;
        }
        Thread tr = new Thread(() -> this.authenticateBlocking(playerId), "VH-Auth");
        tr.setDaemon(true);
        tr.start();
    }

    public boolean authenticateBlocking(UUID playerId) {
        if (playerId == null) {
            return false;
        }
        this.postClientStart(playerId);
        this.champion = this.fetchChampionStatus(playerId);
        return this.champion;
    }

    private void postClientStart(UUID uuid) {
        try {
            URL url = new URL(CLIENT_START_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setDoOutput(true);
            String json = GSON.toJson(Map.of("uuid", uuid.toString()));
            try (OutputStream out = connection.getOutputStream();){
                out.write(json.getBytes(StandardCharsets.UTF_8));
            }
            int code = connection.getResponseCode();
            if (code != 200) {
                VaultMod.LOGGER.warn("Client start post responded with {}", (Object)code);
            }
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Failed to post client start", (Throwable)e);
        }
    }

    private boolean fetchChampionStatus(UUID uuid) {
        try {
            String urlStr = PATREON_REWARD_URL + String.valueOf(uuid);
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                VaultMod.LOGGER.warn("Fetching Patreon tiers failed with code {}", (Object)connection.getResponseCode());
                return false;
            }
            String response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
            RewardResponse resp = (RewardResponse)GSON.fromJson(response, RewardResponse.class);
            List<PatreonTier> tiers = resp.convertTiers();
            VaultMod.LOGGER.info("Fetched {} Patreon tiers for player {}", (Object)tiers.size(), (Object)uuid);
            return tiers.contains((Object)PatreonTier.CHAMPION);
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Failed to fetch Patreon tiers", (Throwable)e);
            return false;
        }
    }
}

