/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.www.metrics;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import iskallia.vault.VaultMod;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class StatsManager {
    private static String baseUrl;
    private static String authUrl;
    private static Supplier<String> mcTokenSupplier;
    private static String authToken;
    private static long tokenExpiry;
    private static final HttpClient CLIENT;
    private static final Gson GSON;

    private StatsManager() {
    }

    public static void configure(String baseUrl, String authUrl, Supplier<String> tokenSupplier) {
        if (!((String)baseUrl).startsWith("http://") && !((String)baseUrl).startsWith("https://")) {
            baseUrl = "http://" + (String)baseUrl;
        }
        StatsManager.baseUrl = baseUrl;
        StatsManager.authUrl = authUrl;
        mcTokenSupplier = tokenSupplier != null ? tokenSupplier : () -> null;
        authToken = null;
        tokenExpiry = 0L;
    }

    private static synchronized boolean ensureToken() {
        if (authUrl == null) {
            return false;
        }
        if (authToken == null || System.currentTimeMillis() >= tokenExpiry) {
            StatsManager.refreshToken();
        }
        return authToken != null;
    }

    private static void refreshToken() {
        String mcToken = mcTokenSupplier.get();
        if (mcToken == null || mcToken.isEmpty()) {
            return;
        }
        try {
            Map<String, String> body = Map.of("mcToken", mcToken);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(authUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON.toJson(body), StandardCharsets.UTF_8)).build();
            HttpResponse<String> resp = CLIENT.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 200) {
                VaultMod.LOGGER.debug("Stats auth server responded with {}", (Object)resp.statusCode());
                return;
            }
            Map data = (Map)GSON.fromJson(resp.body(), Map.class);
            authToken = (String)data.get("token");
            Object expObj = data.get("expires_in");
            if (expObj instanceof Number) {
                Number n = (Number)expObj;
                tokenExpiry = System.currentTimeMillis() + n.longValue() * 1000L;
            } else {
                tokenExpiry = System.currentTimeMillis() + 3600000L;
            }
        }
        catch (Exception e) {
            VaultMod.LOGGER.error("Failed to refresh stats auth token", (Throwable)e);
        }
    }

    public static void increment(String metric, int count) {
        StatsManager.sendPatchAsync(metric, Map.of("delta", count));
    }

    public static void decrement(String metric, int count) {
        StatsManager.sendPatchAsync(metric, Map.of("delta", -count));
    }

    public static void set(String metric, int value) {
        StatsManager.sendSetAsync(metric, value);
    }

    public static Map<String, Integer> getCounts() {
        try {
            if (!StatsManager.ensureToken()) {
                return Collections.emptyMap();
            }
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(baseUrl + "/events/counts")).header("Authorization", "Bearer " + authToken).GET().build();
            HttpResponse<String> resp = CLIENT.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 200) {
                return Collections.emptyMap();
            }
            return (Map)GSON.fromJson(resp.body(), new TypeToken<Map<String, Integer>>(){}.getType());
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private static void sendPatchAsync(String type, Map<String, Object> payload) {
        try {
            if (!StatsManager.ensureToken()) {
                return;
            }
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("type", type);
            body.putAll(payload);
            String json = GSON.toJson(body);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(baseUrl + "/events/" + type)).header("Content-Type", "application/json").header("Authorization", "Bearer " + authToken).method("PATCH", HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
            CLIENT.sendAsync(req, HttpResponse.BodyHandlers.discarding()).orTimeout(3L, TimeUnit.SECONDS).exceptionally(e -> null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendSetAsync(String type, int value) {
        try {
            if (!StatsManager.ensureToken()) {
                return;
            }
            Map<String, Integer> body = Map.of("type", type, "value", value);
            String json = GSON.toJson(body);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(baseUrl + "/state")).header("Content-Type", "application/json").header("Authorization", "Bearer " + authToken).POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
            CLIENT.sendAsync(req, HttpResponse.BodyHandlers.discarding()).orTimeout(3L, TimeUnit.SECONDS).exceptionally(e -> null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        mcTokenSupplier = () -> null;
        CLIENT = HttpClient.newHttpClient();
        GSON = new Gson();
    }
}

