/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.www.patreon;

import com.google.gson.Gson;
import iskallia.vault.util.IskalliaDevs;
import iskallia.vault.www.patreon.PatreonPlayerData;
import iskallia.vault.www.patreon.PatreonTier;
import iskallia.vault.www.patreon.RewardResponse;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.io.IOUtils;

public class PatreonManager {
    private static final PatreonManager INSTANCE = new PatreonManager();
    private static final String DEMO_URL_BASE = "https://demo-api.vaulthunters.gg/";
    private static final String PROD_URL_BASE = "https://api.vaulthunters.gg/";
    private static final Gson GSON = new Gson();
    private final Map<UUID, List<PatreonTier>> loadedTierCache = new HashMap<UUID, List<PatreonTier>>();
    private final Map<String, String> allPlayersCache = new HashMap<String, String>();
    private final Map<UUID, List<PatreonTier>> CACHED_OLD_ALL = new HashMap<UUID, List<PatreonTier>>(){
        {
            this.put(UUID.fromString("6c161feb-1b57-4559-8374-7ed9aaac937c"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("708eb6af-3e7b-4212-a157-dfa8c5d32111"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("899cf199-cc5f-41a3-9e77-397e5a667c89"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("94e39093-9309-49ec-90e2-f4b4e689ac38"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("c37dedcf-b3c8-4e5e-a577-fd8110c497cc"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("bf12dc2f-1ff2-44ae-a38b-8a88aa75e7bb"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("4d679797-5e45-4d88-91e1-22c77335a623"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("489f090c-bbb3-4c87-bd00-ed96a869356e"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("2f26dc50-67c5-4585-bc93-936e3e5df08a"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("3ef799d6-d3c6-49fb-97b5-f944445753f5"), PatreonTier.DWELLER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("47720375-23ce-488f-a363-c8eaf33dc067"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("2ac5b719-60db-4ac8-a1b6-c356a25ecf5f"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("3f36f7e9-7459-43fe-87ce-4e8a5d47da80"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("4d56b6ba-fc57-4f27-8934-2b2c17c9634f"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("444875f9-97ae-42ec-804b-660db2d3e176"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("45868b8e-c52a-413a-b4b6-8919a0f539d7"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("a766216c-f1d3-4928-b837-d0813485ed07"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("a2af867d-f2ee-42a1-8569-d5a5b11d3563"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("d9023446-78a1-4a95-8412-a713f74863a8"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("f697c65e-e118-421e-bbdb-36bdb306c3ae"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("eee8ce04-94b6-4a84-a804-422ce3ec67ec"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("a92cdca7-c943-4358-8cde-3b26632ca3a8"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("b0ae16fa-c66f-4965-b895-25267f67fbcb"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("7e8775d3-492e-466c-bded-a06f94a8291e"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("b83af034-7f7f-4f76-bb8f-52197bcf5b82"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("661eeeb3-b5e7-4681-af31-76eabb3ca689"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("2201f6a8-f7da-4348-8c8e-d142f80017a8"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("683105bb-4322-429c-8b21-f90a5effa6e7"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("6d7ff684-b072-4261-bd49-21b849b161f9"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("6b80e924-64a4-4f7f-8fa4-4000a2c97d6f"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("79557e9c-970e-4f17-a7cf-7171a8340b27"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("3ee64404-59e1-46b7-945f-51018fd4d326"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("878a1ac5-8254-4d77-91cb-504f46e248c6"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("49be59c9-2969-4907-93c7-243002425655"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("d36e0d55-7a19-4a4a-beab-a8fbcb933ac4"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("27c83172-954b-4ccb-b434-c5430be3dce1"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("5ca5094b-a01f-4447-8161-41e1ab3312d1"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("ad8be2f1-9102-4507-87b2-0f7b0feb878e"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("31a55f20-7300-4eda-b094-59b7c5d35733"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("4f3e4547-948b-47ff-b88d-0647905b7fb9"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("face4268-c048-4f75-8269-08543ca69e87"), PatreonTier.DWELLER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("2f26df44-f1d8-439b-9740-157fcc738121"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("a6e75fd8-bf59-4689-9b32-81dcbf25b303"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("fde2d418-ede8-436d-8b1a-bc9586763539"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("b8579e11-a1e4-4ab8-b9ee-33d8379f0d66"), PatreonTier.DWELLER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("ffd3e739-d6d4-4081-bded-1933a76fd36c"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("6aefd519-8f6b-4c3a-bb1b-aac88a8dd57e"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("b1ebbfa0-c0b1-45a0-b3a6-86cb5d322fb5"), PatreonTier.DWELLER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("b7ac86da-6769-4109-8d86-4bf513e89730"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("59c32f6e-9b2e-42ae-b6a4-b5d30fad494b"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("109f8bc7-df04-4102-8ae2-e9c3caec209d"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("89b28550-6cc8-4e93-ab20-abde97a1476d"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("5dfc38a6-8bd4-4961-ab39-e3e0670df24b"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("687d6ee7-cf88-44c6-98e8-e307d626152c"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("6b46ace6-be0b-4533-a4a5-65137b76dffc"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("a8adca9b-7bea-4de3-8304-b4c5f6ddefa5"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("1583e0ca-40ad-49a5-a956-18e496b19a25"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("9d42a8fc-b3a8-4a81-8fc3-f27db1aec8df"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("cb0349aa-bf39-4f87-b527-3bacd72eaf56"), PatreonTier.DWELLER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("a2554a8e-169f-4ff9-858f-ad295080c6f2"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("76ba7a96-61bd-48fb-9330-62944c1abf99"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("111dff66-087b-4948-bbd4-f47ed46af6ac"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("19bcdc67-6162-4176-a485-07f2128bf2cc"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("dcf4f78b-17a6-41f1-ab07-df3a6a09986b"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("4e414b50-343d-4a38-a997-2deef29eae18"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("6c437a80-8642-45fa-a416-450f825cdb75"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("bbb63260-9aa7-444f-87c4-37034b9bb19c"), PatreonTier.DWELLER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("377ed0e7-5a4a-458a-b1e2-5332f71797db"), PatreonTier.CHAMPION.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("f13f1744-bb07-4316-9ffe-11ee7553e617"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("f0053824-1a86-49c4-a519-9ba93a40ddcf"), PatreonTier.CHEESER.getCurrentAndPreviousTiers());
            this.put(UUID.fromString("98076edc-f6c4-4096-b7f6-5e06e6a4d1ae"), PatreonTier.GOBLIN.getCurrentAndPreviousTiers());
        }
    };

    private PatreonManager() {
    }

    public static PatreonManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.loadedTierCache.clear();
        this.allPlayersCache.clear();
    }

    public void clearCache(UUID playerId) {
        this.loadedTierCache.remove(playerId);
    }

    public PatreonPlayerData getPlayerData(UUID playerId) {
        return new PatreonPlayerData(this.getPatreonTiers(playerId));
    }

    public synchronized Map<String, String> getAllPlayers() {
        if (!this.allPlayersCache.isEmpty()) {
            return this.allPlayersCache;
        }
        this.requestAllPatreonTiers(this.allPlayersCache::putAll);
        return new HashMap<String, String>();
    }

    public synchronized List<PatreonTier> getPatreonTiers(UUID playerId) {
        if (IskalliaDevs.isDeveloper(playerId)) {
            return Arrays.asList(PatreonTier.values());
        }
        List<PatreonTier> tiers = this.loadedTierCache.get(playerId);
        if (tiers != null) {
            return tiers;
        }
        this.loadedTierCache.put(playerId, new ArrayList());
        this.requestPatreonTiers(playerId, loadedTiers -> this.loadedTierCache.put(playerId, (List<PatreonTier>)loadedTiers));
        if (this.CACHED_OLD_ALL.containsKey(playerId)) {
            PatreonTier highestCache = PatreonTier.getHighestTier(this.CACHED_OLD_ALL.get(playerId));
            PatreonTier highestLoaded = PatreonTier.getHighestTier(this.loadedTierCache.get(playerId));
            if (highestCache != null && highestLoaded != null && Comparator.comparingInt(PatreonTier::getTier).compare(highestCache, highestLoaded) > 0) {
                return this.CACHED_OLD_ALL.get(playerId);
            }
            return this.loadedTierCache.get(playerId) != null ? this.loadedTierCache.get(playerId) : new ArrayList<PatreonTier>();
        }
        return new ArrayList<PatreonTier>();
    }

    public boolean isUserPatreon(UUID playerId) {
        if (IskalliaDevs.isDeveloper(playerId)) {
            return true;
        }
        if (this.CACHED_OLD_ALL.containsKey(playerId)) {
            return true;
        }
        List<PatreonTier> tiers = this.loadedTierCache.get(playerId);
        return tiers != null && !tiers.isEmpty();
    }

    private void requestPatreonTiers(UUID playerId, Consumer<List<PatreonTier>> onLoad) {
        if (IskalliaDevs.isDeveloper(playerId)) {
            onLoad.accept(Arrays.asList(PatreonTier.values()));
            return;
        }
        if (this.CACHED_OLD_ALL.containsKey(playerId)) {
            onLoad.accept(this.CACHED_OLD_ALL.get(playerId));
            return;
        }
        Thread tr = new Thread(() -> {
            try {
                String urlPart = FMLEnvironment.production ? PROD_URL_BASE : DEMO_URL_BASE;
                URL url = new URL(urlPart + "users/reward?uuid=" + playerId.toString());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    onLoad.accept(new ArrayList());
                    return;
                }
                String response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                RewardResponse responseObj = (RewardResponse)GSON.fromJson(response, RewardResponse.class);
                onLoad.accept(responseObj.convertTiers());
            }
            catch (Exception e) {
                onLoad.accept(new ArrayList());
            }
        }, "Patreon Request - " + playerId.toString());
        tr.setDaemon(true);
        tr.start();
    }

    private void requestAllPatreonTiers(Consumer<Map<String, String>> onLoad) {
        Thread tr = new Thread(() -> {
            try {
                String urlPart = FMLEnvironment.production ? PROD_URL_BASE : DEMO_URL_BASE;
                URL url = new URL(urlPart + "users/reward/list");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    onLoad.accept(new HashMap());
                    return;
                }
                String response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
                Map responseObj = (Map)GSON.fromJson(response, Map.class);
                onLoad.accept(responseObj);
            }
            catch (Exception e) {
                onLoad.accept(new HashMap());
            }
        }, "Patreon Request - All Patreons");
        tr.setDaemon(true);
        tr.start();
    }
}

