/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.www.patreon;

import iskallia.vault.VaultMod;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public enum PatreonTier {
    DWELLER("Vault Dweller", ChatFormatting.RED, "\ud83d\udde1", List.of("Dweller Sword & Axe", "Discord Role", "In Game Credit"), List.of(VaultMod.id("gear/sword/dweller_sword"), VaultMod.id("gear/axe/dweller_axe"))),
    CHEESER("Vault Cheeser", ChatFormatting.YELLOW, "\u231b", List.of("Cheeser Armour Set", "Discord Role", "In Game Credit", "All Previous Tier Rewards!"), List.of(VaultMod.id("gear/armor/darkcheesewarrior/helmet"), VaultMod.id("gear/armor/darkcheesewarrior/chestplate"), VaultMod.id("gear/armor/darkcheesewarrior/leggings"), VaultMod.id("gear/armor/darkcheesewarrior/boots"))),
    GOBLIN("Vault Goblin", TextColor.m_131266_((int)DyeColor.LIME.m_41071_()), "\u2604", List.of("Official Server Access", "Goblin Armour Set", "Discord Role", "In Game Credit", "All Previous Tier Rewards!"), List.of(VaultMod.id("gear/armor/goblin/helmet"), VaultMod.id("gear/armor/goblin/chestplate"), VaultMod.id("gear/armor/goblin/leggings"), VaultMod.id("gear/armor/goblin/boots"))),
    CHAMPION("Vault Champion", ChatFormatting.GOLD, "\u2600", List.of("Pre-Release Access!", "Champion Armour Set", "Official Server Access", "Discord Role", "In Game Credit", "All Previous Tier Rewards!"), List.of(VaultMod.id("gear/armor/champion/helmet"), VaultMod.id("gear/armor/champion/chestplate"), VaultMod.id("gear/armor/champion/leggings"), VaultMod.id("gear/armor/champion/boots"), VaultMod.id("gear/axe/godaxe")));

    private final String name;
    private final TextColor color;
    private final String displayPrefix;
    private final List<String> perks;
    private final List<ResourceLocation> modelRewards;

    private PatreonTier(String name, ChatFormatting color, String displayPrefix, List<String> perks) {
        this(name, TextColor.m_131270_((ChatFormatting)color), displayPrefix, perks, List.of());
    }

    private PatreonTier(String name, TextColor color, String displayPrefix, List<String> perks) {
        this(name, color, displayPrefix, perks, List.of());
    }

    private PatreonTier(String name, ChatFormatting color, String displayPrefix, List<String> perks, List<ResourceLocation> modelRewards) {
        this(name, TextColor.m_131270_((ChatFormatting)color), displayPrefix, perks, modelRewards);
    }

    private PatreonTier(String name, TextColor color, String displayPrefix, List<String> perks, List<ResourceLocation> modelRewards) {
        this.name = name;
        this.color = color;
        this.displayPrefix = displayPrefix;
        this.perks = perks;
        this.modelRewards = modelRewards;
    }

    public static PatreonTier getHighestTier(List<PatreonTier> cacheTier) {
        PatreonTier highest = null;
        for (PatreonTier tier : cacheTier) {
            if (highest != null && !tier.isThisEqualOrHigherThan(highest)) continue;
            highest = tier;
        }
        return highest;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayPrefix() {
        return this.displayPrefix;
    }

    public TextColor getColor() {
        return this.color;
    }

    public MutableComponent getPrefix() {
        return TextComponent.f_131282_.m_6881_().m_7220_((Component)new TextComponent(this.displayPrefix).m_130948_(Style.f_131099_.m_131148_(this.getColor())));
    }

    public List<String> getPerks() {
        return this.perks;
    }

    public List<ResourceLocation> getModelRewards() {
        return this.modelRewards;
    }

    public static PatreonTier fromName(String name) {
        for (PatreonTier tier : PatreonTier.values()) {
            if (!tier.name.equals(name)) continue;
            return tier;
        }
        return null;
    }

    public boolean isThisEqualOrHigherThan(PatreonTier other) {
        return this.ordinal() >= other.ordinal();
    }

    public List<PatreonTier> getCurrentAndPreviousTiers() {
        return List.of(PatreonTier.values()).subList(0, this.ordinal() + 1);
    }

    public static int getTier(PatreonTier o) {
        for (int i = 0; i < PatreonTier.values().length; ++i) {
            if (!PatreonTier.values()[i].equals((Object)o)) continue;
            return i;
        }
        return -1;
    }
}

