/*
 * Decompiled with CFR 0.152.
 */
package com.radimous.tpsdisplay;

import com.radimous.tpsdisplay.Config;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTabListPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="tpsdisplay")
public class Tpsdisplay {
    private static final Component EMPTY_COMPONENT = new TextComponent("");

    public Tpsdisplay() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.m_129921_() % 20 == 0) {
            this.updatePlayerList(server);
        }
    }

    private ChatFormatting getTPSColor(double mspt) {
        if (mspt > 50.0) {
            return ChatFormatting.DARK_RED;
        }
        if (mspt > 40.0) {
            return ChatFormatting.RED;
        }
        if (mspt > 25.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    private void updatePlayerList(MinecraftServer server) {
        double mspt = Mth.m_14078_((long[])server.f_129748_) * 1.0E-6;
        double tps = 1000.0 / Math.max(50.0, mspt);
        ChatFormatting color = this.getTPSColor(mspt);
        MutableComponent tpsComponent = new TextComponent("TPS: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)new TextComponent(String.format(Locale.ROOT, "%.1f", tps)).m_130940_(color)).m_7220_((Component)new TextComponent(" MSPT: ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(String.format(Locale.ROOT, "%.1f", mspt)).m_130940_(color));
        server.m_6846_().m_11314_().forEach(arg_0 -> Tpsdisplay.lambda$updatePlayerList$0((Component)tpsComponent, arg_0));
    }

    private static /* synthetic */ void lambda$updatePlayerList$0(Component tpsComponent, ServerPlayer player) {
        boolean shouldShow = ((List)Config.showList.get()).contains(player.m_142081_().toString());
        if (shouldShow) {
            player.f_8906_.m_141995_((Packet)new ClientboundTabListPacket(EMPTY_COMPONENT, tpsComponent));
        } else {
            player.f_8906_.m_141995_((Packet)new ClientboundTabListPacket(EMPTY_COMPONENT, EMPTY_COMPONENT));
        }
    }
}

