/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.addldata;

import org.jetbrains.annotations.ApiStatus;

public interface ManaHolder {
    @ApiStatus.OverrideOnly
    public int getMana();

    @ApiStatus.OverrideOnly
    public int getMaxMana();

    @ApiStatus.OverrideOnly
    public void setMana(int var1);

    public boolean canRecharge();

    public boolean canProvide();

    public int getConsumptionPriority();

    public boolean canConstructBattery();

    default public int withdrawMana(int cost, boolean simulate) {
        int manaHere = this.getMana();
        if (cost < 0) {
            cost = manaHere;
        }
        if (!simulate) {
            int manaLeft = manaHere - cost;
            this.setMana(manaLeft);
        }
        return Math.min(cost, manaHere);
    }

    default public int insertMana(int amount, boolean simulate) {
        int manaHere = this.getMana();
        int emptySpace = this.getMaxMana() - manaHere;
        if (emptySpace <= 0) {
            return 0;
        }
        if (amount < 0) {
            amount = emptySpace;
        }
        int inserting = Math.min(amount, emptySpace);
        if (!simulate) {
            int newMana = manaHere + inserting;
            this.setMana(newMana);
        }
        return inserting;
    }
}

