/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.mod;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.misc.ScrollQuantity;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public class HexConfig {
    private static CommonConfigAccess common = null;
    private static ClientConfigAccess client = null;
    private static ServerConfigAccess server = null;

    public static boolean anyMatch(List<? extends String> keys, ResourceLocation key) {
        return keys.stream().map(ResourceLocation::new).anyMatch(arg_0 -> ((ResourceLocation)key).equals(arg_0));
    }

    public static boolean noneMatch(List<? extends String> keys, ResourceLocation key) {
        return keys.stream().map(ResourceLocation::new).noneMatch(arg_0 -> ((ResourceLocation)key).equals(arg_0));
    }

    public static CommonConfigAccess common() {
        return common;
    }

    public static ClientConfigAccess client() {
        return client;
    }

    public static ServerConfigAccess server() {
        return server;
    }

    public static void setCommon(CommonConfigAccess access) {
        if (common != null) {
            HexAPI.LOGGER.warn("CommonConfigAccess was replaced! Old {} New {}", (Object)common.getClass().getName(), (Object)access.getClass().getName());
        }
        common = access;
    }

    public static void setClient(ClientConfigAccess access) {
        if (client != null) {
            HexAPI.LOGGER.warn("ClientConfigAccess was replaced! Old {} New {}", (Object)client.getClass().getName(), (Object)access.getClass().getName());
        }
        client = access;
    }

    public static void setServer(ServerConfigAccess access) {
        if (server != null) {
            HexAPI.LOGGER.warn("ServerConfigAccess was replaced! Old {} New {}", (Object)server.getClass().getName(), (Object)access.getClass().getName());
        }
        server = access;
    }

    public static interface CommonConfigAccess {
        public static final int DEFAULT_DUST_MANA_AMOUNT = 10000;
        public static final int DEFAULT_SHARD_MANA_AMOUNT = 50000;
        public static final int DEFAULT_CHARGED_MANA_AMOUNT = 100000;
        public static final double DEFAULT_MANA_TO_HEALTH_RATE = 10000.0;

        public int dustManaAmount();

        public int shardManaAmount();

        public int chargedCrystalManaAmount();

        public double manaToHealthRate();
    }

    public static interface ClientConfigAccess {
        public static final double DEFAULT_PATTERN_POINT_SPEED_MULTIPLIER = 1.0;
        public static final boolean DEFAULT_CTRL_TOGGLES_OFF_STROKE_ORDER = false;
        public static final double DEFAULT_GRID_SNAP_THRESHOLD = 0.5;
        public static final boolean DEFAULT_INVERT_SPELLBOOK_SCROLL = false;
        public static final boolean DEFAULT_INVERT_ABACUS_SCROLL = false;

        public double patternPointSpeedMultiplier();

        public boolean ctrlTogglesOffStrokeOrder();

        public boolean invertSpellbookScrollDirection();

        public boolean invertAbacusScrollDirection();

        public double gridSnapThreshold();
    }

    public static interface ServerConfigAccess {
        public static final int DEFAULT_MAX_RECURSE_DEPTH = 64;
        public static final int DEFAULT_MAX_SPELL_CIRCLE_LENGTH = 1024;
        public static final int DEFAULT_OP_BREAK_HARVEST_LEVEL = 3;
        public static final List<String> DEFAULT_FEW_SCROLL_TABLES = List.of("minecraft:chests/jungle_temple", "minecraft:chests/simple_dungeon", "minecraft:chests/village/village_cartographer");
        public static final List<String> DEFAULT_SOME_SCROLL_TABLES = List.of("minecraft:chests/bastion_treasure", "minecraft:chests/shipwreck_map");
        public static final List<String> DEFAULT_MANY_SCROLL_TABLES = List.of("minecraft:chests/stronghold_library");

        public int opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort();

        public int maxRecurseDepth();

        public int maxSpellCircleLength();

        public boolean isActionAllowed(ResourceLocation var1);

        public boolean isActionAllowedInCircles(ResourceLocation var1);

        public boolean doVillagersTakeOffenseAtMindMurder();

        public ScrollQuantity scrollsForLootTable(ResourceLocation var1);

        default public Tier opBreakHarvestLevel() {
            return switch (this.opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort()) {
                case 0 -> Tiers.WOOD;
                case 1 -> Tiers.STONE;
                case 2 -> Tiers.IRON;
                case 3 -> Tiers.DIAMOND;
                case 4 -> Tiers.NETHERITE;
                default -> throw new RuntimeException("please only return a value in 0<=x<=4");
            };
        }
    }
}

