/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.mishaps;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.misc.HexDamageSources;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.mishaps.Mishap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/api/spell/mishaps/MishapBadBrainsweep;", "Lat/petrak/hexcasting/api/spell/mishaps/Mishap;", "villager", "Lnet/minecraft/world/entity/npc/Villager;", "pos", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/world/entity/npc/Villager;Lnet/minecraft/core/BlockPos;)V", "getPos", "()Lnet/minecraft/core/BlockPos;", "getVillager", "()Lnet/minecraft/world/entity/npc/Villager;", "accentColor", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "errorCtx", "Lat/petrak/hexcasting/api/spell/mishaps/Mishap$Context;", "errorMessage", "Lnet/minecraft/network/chat/Component;", "execute", "", "stack", "", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "particleSpray", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "hexcasting-forge-1.18.2"})
public final class MishapBadBrainsweep
extends Mishap {
    @NotNull
    private final Villager villager;
    @NotNull
    private final BlockPos pos;

    public MishapBadBrainsweep(@NotNull Villager villager2, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)villager2, (String)"villager");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.villager = villager2;
        this.pos = pos;
    }

    @NotNull
    public final Villager getVillager() {
        return this.villager;
    }

    @NotNull
    public final BlockPos getPos() {
        return this.pos;
    }

    @Override
    @NotNull
    public FrozenColorizer accentColor(@NotNull CastingContext ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        return this.dyeColor(DyeColor.GREEN);
    }

    @Override
    public void execute(@NotNull CastingContext ctx, @NotNull Mishap.Context errorCtx, @NotNull List<SpellDatum<?>> stack) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        LivingEntity livingEntity = (LivingEntity)this.villager;
        DamageSource damageSource = HexDamageSources.overcastDamageFrom((Entity)ctx.getCaster());
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"overcastDamageFrom(ctx.caster)");
        Mishap.Companion.trulyHurt(livingEntity, damageSource, this.villager.m_21223_());
    }

    @Override
    @NotNull
    public ParticleSpray particleSpray(@NotNull CastingContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)this.pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null);
    }

    @Override
    @NotNull
    public Component errorMessage(@NotNull CastingContext ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Object[] objectArray = new Object[]{this.blockAtPos(ctx, this.pos)};
        return this.error("bad_brainsweep", objectArray);
    }
}

