/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityAkashicBookshelf
extends HexBlockEntity {
    public static final String TAG_RECORD_POS = "record_pos";
    public static final String TAG_PATTERN = "pattern";
    private BlockPos recordPos = null;
    private HexPattern pattern = null;

    public BlockEntityAkashicBookshelf(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, pWorldPosition, pBlockState);
    }

    @Nullable
    public BlockPos getRecordPos() {
        return this.recordPos;
    }

    @Nullable
    public HexPattern getPattern() {
        return this.pattern;
    }

    public void setNewData(BlockPos recordPos, HexPattern pattern, DatumType type) {
        this.recordPos = recordPos;
        this.pattern = pattern;
        this.m_6596_();
        BlockState worldBs = this.f_58857_.m_8055_(this.m_58899_());
        BlockState oldBs = this.m_58900_();
        if (worldBs.m_60734_() == oldBs.m_60734_()) {
            BlockState newBs = (BlockState)oldBs.m_61124_(BlockAkashicBookshelf.DATUM_TYPE, (Comparable)((Object)type));
            this.f_58857_.m_7731_(this.m_58899_(), newBs, 3);
            this.f_58857_.m_7260_(this.m_58899_(), oldBs, newBs, 3);
        }
    }

    @Override
    protected void saveModData(CompoundTag compoundTag) {
        compoundTag.m_128365_(TAG_RECORD_POS, (Tag)(this.recordPos == null ? new CompoundTag() : NbtUtils.m_129224_((BlockPos)this.recordPos)));
        compoundTag.m_128365_(TAG_PATTERN, (Tag)(this.pattern == null ? new CompoundTag() : this.pattern.serializeToNBT()));
    }

    @Override
    protected void loadModData(CompoundTag compoundTag) {
        CompoundTag recordPos = compoundTag.m_128469_(TAG_RECORD_POS);
        CompoundTag pattern = compoundTag.m_128469_(TAG_PATTERN);
        this.recordPos = recordPos.m_128425_("X", 99) && recordPos.m_128425_("Y", 99) && recordPos.m_128425_("Z", 99) ? NbtUtils.m_129239_((CompoundTag)recordPos) : null;
        this.pattern = HexPattern.isPattern(pattern) ? HexPattern.fromNBT(pattern) : null;
    }
}

