/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.spell.DatumType;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.math.HexDir;
import at.petrak.hexcasting.api.spell.math.HexPattern;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicFloodfiller;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityAkashicRecord
extends HexBlockEntity {
    public static final String TAG_LOOKUP = "lookup";
    public static final String TAG_POS = "pos";
    public static final String TAG_DATUM = "datum";
    public static final String TAG_DIR = "dir";
    private final Map<String, Entry> entries = new HashMap<String, Entry>();

    public BlockEntityAkashicRecord(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.AKASHIC_RECORD_TILE, pWorldPosition, pBlockState);
    }

    public void removeFloodfillerAt(BlockPos pos) {
        this.revalidateAllBookshelves();
    }

    @Nullable
    public BlockPos addNewDatum(HexPattern key, SpellDatum<?> datum) {
        String entryKey = this.getKey(key);
        if (this.entries.containsKey(entryKey)) {
            return null;
        }
        BlockPos openPos = BlockAkashicFloodfiller.floodFillFor(this.f_58858_, this.f_58857_, (pos, bs, world) -> {
            BlockEntityAkashicBookshelf tile;
            BlockEntity patt2056$temp = world.m_7702_(pos);
            return patt2056$temp instanceof BlockEntityAkashicBookshelf && (tile = (BlockEntityAkashicBookshelf)patt2056$temp).getPattern() == null;
        });
        if (openPos != null) {
            BlockEntityAkashicBookshelf tile = (BlockEntityAkashicBookshelf)this.f_58857_.m_7702_(openPos);
            tile.setNewData(this.m_58899_(), key, datum.getType());
            this.entries.put(entryKey, new Entry(openPos, key.getStartDir(), datum.serializeToNBT()));
            this.sync();
            return openPos;
        }
        return null;
    }

    private String getKey(HexPattern key) {
        String angles = key.anglesSignature();
        if (angles.isEmpty()) {
            return "empty";
        }
        return angles;
    }

    @Nullable
    public SpellDatum<?> lookupPattern(HexPattern key, ServerLevel slevel) {
        Entry entry = this.entries.get(this.getKey(key));
        if (entry == null) {
            return null;
        }
        return SpellDatum.fromNBT(entry.datum, slevel);
    }

    public Component getDisplayAt(HexPattern key) {
        Entry entry = this.entries.get(this.getKey(key));
        if (entry != null) {
            return SpellDatum.displayFromNBT(entry.datum);
        }
        return new TranslatableComponent("hexcasting.spelldata.akashic.nopos").m_130940_(ChatFormatting.RED);
    }

    public int getCount() {
        return this.entries.size();
    }

    public void revalidateAllBookshelves() {
        HashSet<BlockPos> validPoses = new HashSet<BlockPos>();
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.add(this.f_58858_);
        while (!todo.isEmpty()) {
            BlockPos here = (BlockPos)todo.remove();
            for (Direction dir : Direction.values()) {
                BlockState bs;
                BlockPos neighbor = here.m_142300_(dir);
                if (!seen.add(neighbor) || !BlockAkashicFloodfiller.canItBeFloodedThrough(neighbor, bs = this.f_58857_.m_8055_(neighbor), this.f_58857_)) continue;
                todo.add(neighbor);
                if (!(this.f_58857_.m_7702_(neighbor) instanceof BlockEntityAkashicBookshelf) || !bs.m_61138_(BlockAkashicBookshelf.DATUM_TYPE) || bs.m_61143_(BlockAkashicBookshelf.DATUM_TYPE) == DatumType.EMPTY) continue;
                validPoses.add(neighbor);
            }
        }
        ArrayList<String> sigs = new ArrayList<String>(this.entries.keySet());
        for (String sig : sigs) {
            Entry entry = this.entries.get(sig);
            if (validPoses.contains(entry.pos)) continue;
            this.entries.remove(sig);
            BlockEntity blockEntity = this.f_58857_.m_7702_(entry.pos);
            if (!(blockEntity instanceof BlockEntityAkashicBookshelf)) continue;
            BlockEntityAkashicBookshelf shelf = (BlockEntityAkashicBookshelf)blockEntity;
            shelf.setNewData(null, null, DatumType.EMPTY);
        }
        this.sync();
    }

    @Override
    protected void saveModData(CompoundTag compoundTag) {
        CompoundTag lookupTag = new CompoundTag();
        this.entries.forEach((sig, entry) -> {
            CompoundTag t = new CompoundTag();
            t.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry.pos));
            t.m_128365_(TAG_DATUM, (Tag)entry.datum);
            t.m_128344_(TAG_DIR, (byte)entry.startDir.ordinal());
            lookupTag.m_128365_(sig, (Tag)t);
        });
        compoundTag.m_128365_(TAG_LOOKUP, (Tag)lookupTag);
    }

    @Override
    protected void loadModData(CompoundTag compoundTag) {
        CompoundTag lookupTag = compoundTag.m_128469_(TAG_LOOKUP);
        this.entries.clear();
        Set sigs = lookupTag.m_128431_();
        for (String sig : sigs) {
            CompoundTag entryTag = lookupTag.m_128469_(sig);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)entryTag.m_128469_(TAG_POS));
            HexDir dir = HexDir.values()[entryTag.m_128445_(TAG_DIR)];
            CompoundTag datum = entryTag.m_128469_(TAG_DATUM);
            this.entries.put(sig, new Entry(pos, dir, datum));
        }
    }

    private record Entry(BlockPos pos, HexDir startDir, CompoundTag datum) {
    }
}

