/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.operators.spells;

import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellDatum;
import at.petrak.hexcasting.api.spell.SpellOperator;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.SpellContinuation;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.spell.mishaps.MishapNotEnoughArgs;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ:\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00152\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u001e"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpPotionEffect;", "Lat/petrak/hexcasting/api/spell/SpellOperator;", "effect", "Lnet/minecraft/world/effect/MobEffect;", "baseCost", "", "allowPotency", "", "potencyCubic", "isGreat", "(Lnet/minecraft/world/effect/MobEffect;IZZZ)V", "getAllowPotency", "()Z", "argc", "getArgc", "()I", "getBaseCost", "getEffect", "()Lnet/minecraft/world/effect/MobEffect;", "getPotencyCubic", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/SpellDatum;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "Spell", "hexcasting-forge-1.18.2"})
public final class OpPotionEffect
implements SpellOperator {
    @NotNull
    private final MobEffect effect;
    private final int baseCost;
    private final boolean allowPotency;
    private final boolean potencyCubic;
    private final boolean isGreat;

    public OpPotionEffect(@NotNull MobEffect effect, int baseCost, boolean allowPotency, boolean potencyCubic, boolean isGreat) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.effect = effect;
        this.baseCost = baseCost;
        this.allowPotency = allowPotency;
        this.potencyCubic = potencyCubic;
        this.isGreat = isGreat;
    }

    @NotNull
    public final MobEffect getEffect() {
        return this.effect;
    }

    public final int getBaseCost() {
        return this.baseCost;
    }

    public final boolean getAllowPotency() {
        return this.allowPotency;
    }

    public final boolean getPotencyCubic() {
        return this.potencyCubic;
    }

    @Override
    public boolean isGreat() {
        return this.isGreat;
    }

    @Override
    public int getArgc() {
        return this.allowPotency ? 3 : 2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends SpellDatum<?>> args, @NotNull CastingContext ctx) {
        double d;
        int idx$iv;
        void $this$getChecked$iv22;
        int idx$iv2;
        void $this$getChecked$iv;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List<? extends SpellDatum<?>> list = args;
        boolean bl = false;
        int argc$iv22 = this.getArgc();
        boolean $i$f$getChecked = false;
        void var8_10 = $this$getChecked$iv;
        if (idx$iv2 > CollectionsKt.getLastIndex((List)var8_10)) {
            void it$iv = idx$iv2;
            boolean bl2 = false;
            throw new MishapNotEnoughArgs((int)(idx$iv2 + true), $this$getChecked$iv.size());
        }
        SpellDatum x$iv = (SpellDatum)var8_10.get(idx$iv2);
        if (!(x$iv.getPayload() instanceof LivingEntity)) {
            throw MishapInvalidIota.Companion.ofClass(x$iv, argc$iv22 == 0 ? idx$iv2 : argc$iv22 - (idx$iv2 + true), LivingEntity.class);
        }
        LivingEntity target = (LivingEntity)x$iv.getPayload();
        if (target instanceof ArmorStand) {
            throw MishapInvalidIota.Companion.ofClass(SpellDatum.Companion.make(target), 0, LivingEntity.class);
        }
        List<? extends SpellDatum<?>> argc$iv22 = args;
        $i$f$getChecked = true;
        int argc$iv322 = this.getArgc();
        int $i$f$getChecked2 = 0;
        void bl2 = $this$getChecked$iv22;
        if (idx$iv > CollectionsKt.getLastIndex((List)bl2)) {
            void it$iv = idx$iv;
            boolean bl3 = false;
            throw new MishapNotEnoughArgs((int)(idx$iv + true), $this$getChecked$iv22.size());
        }
        SpellDatum x$iv2 = (SpellDatum)bl2.get(idx$iv);
        if (!(x$iv2.getPayload() instanceof Double)) {
            throw MishapInvalidIota.Companion.ofClass(x$iv2, argc$iv322 == 0 ? idx$iv : argc$iv322 - (idx$iv + true), Double.class);
        }
        double $this$getChecked$iv22 = ((Number)x$iv2.getPayload()).doubleValue();
        double argc$iv322 = 0.0;
        double duration = Math.max($this$getChecked$iv22, argc$iv322);
        if (this.allowPotency) {
            int idx$iv3;
            void $this$getChecked$iv3;
            List<? extends SpellDatum<?>> argc$iv322 = args;
            $i$f$getChecked2 = 2;
            int argc$iv = this.getArgc();
            boolean $i$f$getChecked3 = false;
            void var12_25 = $this$getChecked$iv3;
            if (idx$iv3 > CollectionsKt.getLastIndex((List)var12_25)) {
                void it$iv = idx$iv3;
                boolean bl4 = false;
                throw new MishapNotEnoughArgs((int)(idx$iv3 + true), $this$getChecked$iv3.size());
            }
            SpellDatum x$iv3 = (SpellDatum)var12_25.get(idx$iv3);
            if (!(x$iv3.getPayload() instanceof Double)) {
                throw MishapInvalidIota.Companion.ofClass(x$iv3, argc$iv == 0 ? idx$iv3 : argc$iv - (idx$iv3 + true), Double.class);
            }
            d = RangesKt.coerceIn((double)((Number)x$iv3.getPayload()).doubleValue(), (double)1.0, (double)128.0);
        } else {
            d = 1.0;
        }
        double potency = d;
        ctx.assertEntityInRange((Entity)target);
        double cost = (double)this.baseCost * duration * (this.potencyCubic ? potency * potency * potency : potency * potency);
        Spell spell = new Spell(this.effect, target, duration, potency);
        Integer n = (int)cost;
        Vec3 vec3 = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position().add(0.\u2026get.eyeHeight / 2.0, 0.0)");
        return new Triple((Object)spell, (Object)n, (Object)CollectionsKt.listOf((Object)ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)));
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<SpellDatum<?>> stack, @NotNull SpellDatum<?> local, @NotNull CastingContext ctx) {
        return SpellOperator.DefaultImpls.operate(this, continuation, stack, local, ctx);
    }

    @Override
    public boolean getAlwaysProcessGreatSpell() {
        return SpellOperator.DefaultImpls.getAlwaysProcessGreatSpell(this);
    }

    @Override
    public boolean getCausesBlindDiversion() {
        return SpellOperator.DefaultImpls.getCausesBlindDiversion(this);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return SpellOperator.DefaultImpls.getDisplayName(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/operators/spells/OpPotionEffect$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "effect", "Lnet/minecraft/world/effect/MobEffect;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "duration", "", "potency", "(Lnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/entity/LivingEntity;DD)V", "getDuration", "()D", "getEffect", "()Lnet/minecraft/world/effect/MobEffect;", "getPotency", "getTarget", "()Lnet/minecraft/world/entity/LivingEntity;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "hexcasting-forge-1.18.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final MobEffect effect;
        @NotNull
        private final LivingEntity target;
        private final double duration;
        private final double potency;

        public Spell(@NotNull MobEffect effect, @NotNull LivingEntity target, double duration, double potency) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.effect = effect;
            this.target = target;
            this.duration = duration;
            this.potency = potency;
        }

        @NotNull
        public final MobEffect getEffect() {
            return this.effect;
        }

        @NotNull
        public final LivingEntity getTarget() {
            return this.target;
        }

        public final double getDuration() {
            return this.duration;
        }

        public final double getPotency() {
            return this.potency;
        }

        @Override
        public void cast(@NotNull CastingContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.duration > 0.05) {
                MobEffectInstance effectInst = new MobEffectInstance(this.effect, (int)(this.duration * (double)20), (int)this.potency - 1);
                this.target.m_7292_(effectInst);
            }
        }
    }
}

