/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.colorizer;

import at.petrak.hexcasting.api.addldata.Colorizer;
import at.petrak.hexcasting.api.item.ColorizerItem;
import java.util.EnumMap;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemPrideColorizer
extends Item
implements ColorizerItem {
    public final Type type;
    private static final EnumMap<Type, int[]> COLORS = (EnumMap)Util.m_137537_(() -> {
        EnumMap<Type, int[]> out = new EnumMap<Type, int[]>(Type.class);
        out.put(Type.AGENDER, new int[]{1483020, 0xFFFFFF, 8028289, 3157808});
        out.put(Type.AROACE, new int[]{7475388, 15463271, 0xFFFFFF, 8576235, 3100120});
        out.put(Type.AROMANTIC, new int[]{1483020, 8579979, 0xFFFFFF, 8028289, 3157808});
        out.put(Type.ASEXUAL, new int[]{0x333233, 10133409, 0xFFFFFF, 7475388});
        out.put(Type.BISEXUAL, new int[]{14370303, 10234832, 6853844});
        out.put(Type.DEMIBOY, new int[]{10133409, 0xA9FFFF, 0xFFFFFF});
        out.put(Type.DEMIGIRL, new int[]{10133409, 16560639, 0xFFFFFF});
        out.put(Type.GAY, new int[]{14167866, 14714943, 15463271, 2995224, 3100120});
        out.put(Type.GENDERFLUID, new int[]{16493817, 0xFFFFFF, 10234832, 0x333233, 3100120});
        out.put(Type.GENDERQUEER, new int[]{13269231, 0xFFFFFF, 2995224});
        out.put(Type.INTERSEX, new int[]{15463271, 7475388});
        out.put(Type.LESBIAN, new int[]{14167866, 15710333, 0xFFFFFF, 16493817, 10682978});
        out.put(Type.NONBINARY, new int[]{15463271, 0xFFFFFF, 7475388, 0x333233});
        out.put(Type.PANSEXUAL, new int[]{14842095, 15463271, 6996708});
        out.put(Type.PLURAL, new int[]{3196575, 3440095, 7028670, 0});
        out.put(Type.TRANSGENDER, new int[]{15438570, 0xFFFFFF, 6996708});
        for (int[] color : out.values()) {
            int i = 0;
            while (i < color.length) {
                int n = i++;
                color[n] = color[n] | 0xFF000000;
            }
        }
        return out;
    });

    public ItemPrideColorizer(Type type, Item.Properties pProperties) {
        super(pProperties);
        this.type = type;
    }

    @Override
    public int color(ItemStack stack, UUID owner, float time, Vec3 position) {
        return Colorizer.morphBetweenColors(this.getColors(), new Vec3(0.1, 0.1, 0.1), time / 20.0f / 20.0f, position);
    }

    public int[] getColors() {
        return COLORS.get((Object)this.type);
    }

    public static enum Type {
        AGENDER,
        AROACE,
        AROMANTIC,
        ASEXUAL,
        BISEXUAL,
        DEMIBOY,
        DEMIGIRL,
        GAY,
        GENDERFLUID,
        GENDERQUEER,
        INTERSEX,
        LESBIAN,
        NONBINARY,
        PANSEXUAL,
        PLURAL,
        TRANSGENDER;


        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

