/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.items.ItemAbacus;
import at.petrak.hexcasting.common.items.ItemFocus;
import at.petrak.hexcasting.common.items.ItemJewelerHammer;
import at.petrak.hexcasting.common.items.ItemLens;
import at.petrak.hexcasting.common.items.ItemScroll;
import at.petrak.hexcasting.common.items.ItemSlate;
import at.petrak.hexcasting.common.items.ItemSpellbook;
import at.petrak.hexcasting.common.items.ItemWand;
import at.petrak.hexcasting.common.items.colorizer.ItemDyeColorizer;
import at.petrak.hexcasting.common.items.colorizer.ItemPrideColorizer;
import at.petrak.hexcasting.common.items.colorizer.ItemUUIDColorizer;
import at.petrak.hexcasting.common.items.magic.ItemArtifact;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.items.magic.ItemCypher;
import at.petrak.hexcasting.common.items.magic.ItemManaBattery;
import at.petrak.hexcasting.common.items.magic.ItemTrinket;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;

public class HexItems {
    private static final Map<ResourceLocation, Item> ITEMS = new LinkedHashMap<ResourceLocation, Item>();
    public static final Item AMETHYST_DUST = HexItems.make("amethyst_dust", new Item(HexItems.props()));
    public static final Item CHARGED_AMETHYST = HexItems.make("charged_amethyst", new Item(HexItems.props()));
    public static final ItemWand WAND_OAK = HexItems.make("wand_oak", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_SPRUCE = HexItems.make("wand_spruce", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_BIRCH = HexItems.make("wand_birch", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_JUNGLE = HexItems.make("wand_jungle", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_ACACIA = HexItems.make("wand_acacia", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_DARK_OAK = HexItems.make("wand_dark_oak", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_CRIMSON = HexItems.make("wand_crimson", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_WARPED = HexItems.make("wand_warped", new ItemWand(HexItems.unstackable()));
    public static final ItemWand WAND_AKASHIC = HexItems.make("wand_akashic", new ItemWand(HexItems.unstackable()));
    public static final ItemLens SCRYING_LENS = HexItems.make("lens", new ItemLens(IXplatAbstractions.INSTANCE.addEquipSlotFabric(EquipmentSlot.HEAD).m_41487_(1).m_41491_(IXplatAbstractions.INSTANCE.getTab())));
    public static final ItemAbacus ABACUS = HexItems.make("abacus", new ItemAbacus(HexItems.unstackable()));
    public static final ItemFocus FOCUS = HexItems.make("focus", new ItemFocus(HexItems.unstackable()));
    public static final ItemSpellbook SPELLBOOK = HexItems.make("spellbook", new ItemSpellbook(HexItems.unstackable()));
    public static final ItemCypher CYPHER = HexItems.make("cypher", new ItemCypher(HexItems.unstackable()));
    public static final ItemTrinket TRINKET = HexItems.make("trinket", new ItemTrinket(HexItems.unstackable()));
    public static final ItemArtifact ARTIFACT = HexItems.make("artifact", new ItemArtifact(HexItems.unstackable()));
    public static final ItemJewelerHammer JEWELER_HAMMER = HexItems.make("jeweler_hammer", new ItemJewelerHammer((Tier)Tiers.IRON, 0, -2.8f, HexItems.props().m_41487_(1).m_41499_(Tiers.DIAMOND.m_6609_())));
    public static final ItemScroll SCROLL_SMOL = HexItems.make("scroll_small", new ItemScroll(HexItems.props(), 1));
    public static final ItemScroll SCROLL_MEDIUM = HexItems.make("scroll_medium", new ItemScroll(HexItems.props(), 2));
    public static final ItemScroll SCROLL_LARGE = HexItems.make("scroll", new ItemScroll(HexItems.props(), 3));
    public static final ItemSlate SLATE = HexItems.make("slate", new ItemSlate(HexBlocks.SLATE, HexItems.props()));
    public static final ItemManaBattery BATTERY = HexItems.make("battery", new ItemManaBattery(HexItems.unstackable()));
    public static final EnumMap<DyeColor, ItemDyeColorizer> DYE_COLORIZERS = (EnumMap)Util.m_137537_(() -> {
        EnumMap<DyeColor, ItemDyeColorizer> out = new EnumMap<DyeColor, ItemDyeColorizer>(DyeColor.class);
        for (DyeColor dye : DyeColor.values()) {
            out.put(dye, HexItems.make("dye_colorizer_" + dye.m_41065_(), new ItemDyeColorizer(dye, HexItems.unstackable())));
        }
        return out;
    });
    public static final EnumMap<ItemPrideColorizer.Type, ItemPrideColorizer> PRIDE_COLORIZERS = (EnumMap)Util.m_137537_(() -> {
        EnumMap<ItemPrideColorizer.Type, ItemPrideColorizer> out = new EnumMap<ItemPrideColorizer.Type, ItemPrideColorizer>(ItemPrideColorizer.Type.class);
        for (ItemPrideColorizer.Type politicsInMyVidya : ItemPrideColorizer.Type.values()) {
            out.put(politicsInMyVidya, HexItems.make("pride_colorizer_" + politicsInMyVidya.getName(), new ItemPrideColorizer(politicsInMyVidya, HexItems.unstackable())));
        }
        return out;
    });
    public static final Item UUID_COLORIZER = HexItems.make("uuid_colorizer", new ItemUUIDColorizer(HexItems.unstackable()));
    public static final Item SUBMARINE_SANDWICH = HexItems.make("sub_sandwich", new Item(HexItems.props().m_41489_(new FoodProperties.Builder().m_38760_(14).m_38758_(1.2f).m_38767_())));
    public static final ItemCreativeUnlocker CREATIVE_UNLOCKER = HexItems.make("creative_unlocker", new ItemCreativeUnlocker(HexItems.unstackable().m_41497_(Rarity.EPIC).m_41489_(new FoodProperties.Builder().m_38760_(20).m_38758_(1.0f).m_38765_().m_38767_())));

    public static void registerItems(BiConsumer<Item, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Item> e : ITEMS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static Item.Properties props() {
        return new Item.Properties().m_41491_(IXplatAbstractions.INSTANCE.getTab());
    }

    public static Item.Properties unstackable() {
        return HexItems.props().m_41487_(1);
    }

    private static <T extends Item> T make(ResourceLocation id, T item) {
        Item old = ITEMS.put(id, item);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return item;
    }

    private static <T extends Item> T make(String id, T item) {
        return HexItems.make(HexAPI.modLoc(id), item);
    }

    public static ItemStack tabIcon() {
        return new ItemStack((ItemLike)SPELLBOOK);
    }
}

