/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.network;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.client.gui.GuiSpellcasting;
import at.petrak.hexcasting.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public record MsgOpenSpellGuiAck(InteractionHand hand, List<ResolvedPattern> patterns, List<Component> components) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("cgui");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgOpenSpellGuiAck deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        int patternsLen = buf.readInt();
        ArrayList<ResolvedPattern> patterns = new ArrayList<ResolvedPattern>(patternsLen);
        for (int i = 0; i < patternsLen; ++i) {
            patterns.add(ResolvedPattern.fromNBT(buf.m_130261_()));
        }
        int descsLen = buf.readInt();
        ArrayList<Component> desc = new ArrayList<Component>(descsLen);
        for (int i = 0; i < descsLen; ++i) {
            desc.add(buf.m_130238_());
        }
        return new MsgOpenSpellGuiAck(hand, patterns, desc);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.writeInt(this.patterns.size());
        for (ResolvedPattern pattern : this.patterns) {
            buf.m_130079_(pattern.serializeToNBT());
        }
        buf.writeInt(this.components.size());
        for (Component desc : this.components) {
            buf.m_130083_(desc);
        }
    }

    public static void handle(final MsgOpenSpellGuiAck msg) {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                mc.m_91152_((Screen)new GuiSpellcasting(msg.hand(), msg.patterns(), msg.components()));
            }
        });
    }
}

