/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.xplat;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.DataHolder;
import at.petrak.hexcasting.api.addldata.HexHolder;
import at.petrak.hexcasting.api.addldata.ManaHolder;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.spell.casting.CastingHarness;
import at.petrak.hexcasting.api.spell.casting.ResolvedPattern;
import at.petrak.hexcasting.common.network.IMessage;
import at.petrak.hexcasting.interop.pehkui.PehkuiInterop;
import at.petrak.hexcasting.xplat.IXplatTags;
import at.petrak.hexcasting.xplat.Platform;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IXplatAbstractions {
    public static final IXplatAbstractions INSTANCE = IXplatAbstractions.find();

    public Platform platform();

    public boolean isModPresent(String var1);

    public boolean isPhysicalClient();

    public void initPlatformSpecific();

    public void sendPacketToPlayer(ServerPlayer var1, IMessage var2);

    public void sendPacketNear(Vec3 var1, double var2, ServerLevel var4, IMessage var5);

    public Packet<?> toVanillaClientboundPacket(IMessage var1);

    public double getReachDistance(Player var1);

    public void brainsweep(Mob var1);

    public void setColorizer(Player var1, FrozenColorizer var2);

    public void setSentinel(Player var1, Sentinel var2);

    public void setFlight(ServerPlayer var1, FlightAbility var2);

    public void setHarness(ServerPlayer var1, @Nullable CastingHarness var2);

    public void setPatterns(ServerPlayer var1, List<ResolvedPattern> var2);

    public boolean isBrainswept(Mob var1);

    public FlightAbility getFlight(ServerPlayer var1);

    public FrozenColorizer getColorizer(Player var1);

    public Sentinel getSentinel(Player var1);

    public CastingHarness getHarness(ServerPlayer var1, InteractionHand var2);

    public List<ResolvedPattern> getPatterns(ServerPlayer var1);

    public void clearCastingData(ServerPlayer var1);

    @Nullable
    public ManaHolder findManaHolder(ItemStack var1);

    @Nullable
    public DataHolder findDataHolder(ItemStack var1);

    @Nullable
    public DataHolder findDataHolder(Entity var1);

    @Nullable
    public HexHolder findHexHolder(ItemStack var1);

    public boolean isColorizer(ItemStack var1);

    public int getRawColor(FrozenColorizer var1, float var2, Vec3 var3);

    public Item.Properties addEquipSlotFabric(EquipmentSlot var1);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    public boolean tryPlaceFluid(Level var1, InteractionHand var2, BlockPos var3, Fluid var4);

    public boolean drainAllFluid(Level var1, BlockPos var2);

    public CreativeModeTab getTab();

    public boolean isCorrectTierForDrops(Tier var1, BlockState var2);

    public ResourceLocation getID(Block var1);

    public ResourceLocation getID(Item var1);

    public ResourceLocation getID(VillagerProfession var1);

    public Ingredient getUnsealedIngredient(ItemStack var1);

    public IXplatTags tags();

    public LootItemCondition.Builder isShearsCondition();

    public String getModName(String var1);

    public boolean isBreakingAllowed(Level var1, BlockPos var2, BlockState var3, Player var4);

    public boolean isPlacingAllowed(Level var1, BlockPos var2, ItemStack var3, Player var4);

    public PehkuiInterop.ApiAbstraction getPehkuiApi();

    private static IXplatAbstractions find() {
        List<ServiceLoader.Provider<IXplatAbstractions>> providers = ServiceLoader.load(IXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("There should be exactly one IXplatAbstractions implementation on the classpath. Found: " + names);
        }
        ServiceLoader.Provider<IXplatAbstractions> provider = providers.get(0);
        HexAPI.LOGGER.debug("Instantiating xplat impl: " + provider.type().getName());
        return provider.get();
    }
}

