/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.function.Function;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.model.light.BowModel;
import me.paulf.fairylights.client.renderer.block.entity.GarlandTinselRenderer;
import me.paulf.fairylights.client.renderer.block.entity.GarlandVineRenderer;
import me.paulf.fairylights.client.renderer.block.entity.HangingLightsRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LetterBuntingRenderer;
import me.paulf.fairylights.client.renderer.block.entity.PennantBuntingRenderer;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.GarlandTinselConnection;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.LetterBuntingConnection;
import me.paulf.fairylights.server.connection.PennantBuntingConnection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FenceFastener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;

public class FastenerRenderer {
    private final HangingLightsRenderer hangingLights;
    private final GarlandVineRenderer garland;
    private final GarlandTinselRenderer tinsel;
    private final PennantBuntingRenderer pennants;
    private final LetterBuntingRenderer letters;
    private final BowModel bow;

    public FastenerRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        this.hangingLights = new HangingLightsRenderer(baker);
        this.garland = new GarlandVineRenderer(baker);
        this.tinsel = new GarlandTinselRenderer(baker);
        this.pennants = new PennantBuntingRenderer(baker);
        this.letters = new LetterBuntingRenderer(baker);
        this.bow = new BowModel(baker.apply(FLModelLayers.BOW));
    }

    public void render(Fastener<?> fastener, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        boolean renderBow = true;
        for (Connection conn : fastener.getAllConnections()) {
            if (conn.getFastener() == fastener) {
                this.renderConnection(delta, matrix, source, packedLight, packedOverlay, conn);
            }
            if (!renderBow || !(conn instanceof GarlandVineConnection) || !this.renderBow(fastener, matrix, source, packedLight, packedOverlay)) continue;
            renderBow = false;
        }
    }

    private boolean renderBow(Fastener<?> fastener, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        if (fastener instanceof FenceFastener) {
            Level world = fastener.getWorld();
            if (world == null) {
                return false;
            }
            BlockState state = world.m_8055_(fastener.getPos());
            if (!state.m_204336_(Tags.Blocks.FENCES)) {
                return false;
            }
            VertexConsumer buf = ClientProxy.SOLID_TEXTURE.m_119194_(source, RenderType::m_110452_);
            float offset = -0.09375f;
            boolean north = (Boolean)state.m_61143_((Property)FenceBlock.f_52309_);
            boolean east = (Boolean)state.m_61143_((Property)FenceBlock.f_52310_);
            boolean south = (Boolean)state.m_61143_((Property)FenceBlock.f_52311_);
            boolean west = (Boolean)state.m_61143_((Property)FenceBlock.f_52312_);
            boolean tryDirX = true;
            boolean bow = false;
            if (!north && (east || west)) {
                this.bow(matrix, Direction.NORTH, -0.09375f, buf, packedLight, packedOverlay);
                tryDirX = false;
                bow = true;
            }
            if (!south && (east || west)) {
                this.bow(matrix, Direction.SOUTH, -0.09375f, buf, packedLight, packedOverlay);
                tryDirX = false;
                bow = true;
            }
            if (tryDirX) {
                if (!east && (north || south)) {
                    this.bow(matrix, Direction.EAST, -0.09375f, buf, packedLight, packedOverlay);
                    bow = true;
                }
                if (!west && (north || south)) {
                    this.bow(matrix, Direction.WEST, -0.09375f, buf, packedLight, packedOverlay);
                    bow = true;
                }
            }
            return bow;
        }
        if (fastener.getFacing().m_122434_() != Direction.Axis.Y) {
            VertexConsumer buf = ClientProxy.SOLID_TEXTURE.m_119194_(source, RenderType::m_110452_);
            this.bow(matrix, fastener.getFacing(), 0.0f, buf, packedLight, packedOverlay);
            return true;
        }
        return false;
    }

    private void bow(PoseStack matrix, Direction dir, float offset, VertexConsumer buf, int packedLight, int packedOverlay) {
        matrix.m_85836_();
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - dir.m_122435_()));
        if (offset != 0.0f) {
            matrix.m_85837_(0.0, 0.0, (double)offset);
        }
        this.bow.m_7695_(matrix, buf, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.m_85849_();
    }

    private void renderConnection(float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay, Connection conn) {
        if (conn instanceof HangingLightsConnection) {
            this.hangingLights.render((HangingLightsConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandVineConnection) {
            this.garland.render((GarlandVineConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof GarlandTinselConnection) {
            this.tinsel.render((GarlandTinselConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof PennantBuntingConnection) {
            this.pennants.render((PennantBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        } else if (conn instanceof LetterBuntingConnection) {
            this.letters.render((LetterBuntingConnection)conn, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    public static void renderBakedModel(ResourceLocation path, PoseStack matrix, VertexConsumer buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(Minecraft.m_91087_().m_91304_().getModel(path), matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(BakedModel model, PoseStack matrix, VertexConsumer buf, float r, float g, float b, int packedLight, int packedOverlay) {
        FastenerRenderer.renderBakedModel(model, ItemTransforms.TransformType.FIXED, matrix, buf, r, g, b, packedLight, packedOverlay);
    }

    public static void renderBakedModel(BakedModel model, ItemTransforms.TransformType type, PoseStack matrix, VertexConsumer buf, float r, float g, float b, int packedLight, int packedOverlay) {
        model.m_7442_().m_111808_(type).m_111763_(false, matrix);
        for (Direction side : Direction.values()) {
            for (BakedQuad quad : model.getQuads(null, side, new Random(42L), (IModelData)EmptyModelData.INSTANCE)) {
                buf.m_85987_(matrix.m_85850_(), quad, r, g, b, packedLight, packedOverlay);
            }
        }
        for (BakedQuad quad : model.getQuads(null, null, new Random(42L), (IModelData)EmptyModelData.INSTANCE)) {
            buf.m_85987_(matrix.m_85850_(), quad, r, g, b, packedLight, packedOverlay);
        }
    }
}

