/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LightRenderer;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.util.FLMth;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;

public class HangingLightsRenderer
extends ConnectionRenderer<HangingLightsConnection> {
    private final LightRenderer lights;

    public HangingLightsRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        super(baker, FLModelLayers.LIGHTS_WIRE);
        this.lights = new LightRenderer(baker);
    }

    @Override
    protected int getWireColor(HangingLightsConnection conn) {
        return conn.getString().getColor();
    }

    @Override
    public void render(HangingLightsConnection conn, float delta, PoseStack matrix, MultiBufferSource source, int packedLight, int packedOverlay) {
        super.render(conn, delta, matrix, source, packedLight, packedOverlay);
        Light[] lights = (Light[])conn.getFeatures();
        if (lights == null) {
            return;
        }
        LightRenderer.Data data = this.lights.start(source);
        for (int i = 0; i < lights.length; ++i) {
            Light light = lights[i];
            Vec3 pos = light.getPoint(delta);
            matrix.m_85836_();
            matrix.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            matrix.m_85845_(Vector3f.f_122225_.m_122270_(-light.getYaw(delta)));
            if (light.parallelsCord()) {
                matrix.m_85845_(Vector3f.f_122227_.m_122270_(light.getPitch(delta)));
            }
            matrix.m_85845_(Vector3f.f_122223_.m_122270_(light.getRoll(delta)));
            if (light.getVariant() != SimpleLightVariant.FAIRY_LIGHT) {
                matrix.m_85845_(Vector3f.f_122225_.m_122270_(FLMth.mod((float)FLMth.hash(i) * ((float)Math.PI / 180), (float)Math.PI * 2) + 0.7853982f));
            }
            matrix.m_85837_(0.0, (double)(-light.getDescent()), 0.0);
            this.lights.render(matrix, data, light, i, delta, packedLight, packedOverlay);
            matrix.m_85849_();
        }
    }

    public static LayerDefinition wireLayer() {
        return ConnectionRenderer.WireModel.createLayer(0, 0, 2);
    }
}

