/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.connection.ConnectionTypes;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.util.RegistryObjects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class HangingLightsConnectionItem
extends ConnectionItem {
    public HangingLightsConnectionItem(Item.Properties properties) {
        super(properties, ConnectionTypes.HANGING_LIGHTS);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null) {
            ResourceLocation name = RegistryObjects.getName(HangingLightsConnectionItem.getString(compound));
            tooltip.add((Component)new TranslatableComponent("item." + name.m_135827_() + "." + name.m_135815_()).m_130940_(ChatFormatting.GRAY));
        }
        if (compound != null && compound.m_128425_("pattern", 9)) {
            ListTag tagList = compound.m_128437_("pattern", 10);
            int tagCount = tagList.size();
            if (tagCount > 0) {
                tooltip.add(TextComponent.f_131282_);
            }
            for (int i = 0; i < tagCount; ++i) {
                ItemStack lightStack = ItemStack.m_41712_((CompoundTag)tagList.m_128728_(i));
                tooltip.add(lightStack.m_41786_());
                lightStack.m_41720_().m_7373_(lightStack, world, tooltip, flag);
            }
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            for (DyeColor color : DyeColor.values()) {
                subItems.add((Object)FLCraftingRecipes.makeHangingLights(new ItemStack((ItemLike)this), color));
            }
        }
    }

    public static StringType getString(CompoundTag tag) {
        return Objects.requireNonNull((StringType)FairyLights.STRING_TYPES.get().getValue(ResourceLocation.m_135820_((String)tag.m_128461_("string"))));
    }

    public static void setString(CompoundTag tag, StringType string) {
        tag.m_128359_("string", RegistryObjects.getName(string).toString());
    }
}

