/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.LightVariant;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LightItem
extends BlockItem {
    private final LightBlock light;

    public LightItem(LightBlock light, Item.Properties properties) {
        super((Block)light, properties);
        this.light = light;
    }

    public LightBlock getBlock() {
        return this.light;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return LightVariant.provider(this.light.getVariant());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (tag.m_128471_("twinkle")) {
                tooltip.add((Component)new TranslatableComponent("item.fairyLights.twinkle").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
            if (tag.m_128425_("colors", 9)) {
                ListTag colors = tag.m_128437_("colors", 3);
                for (int i = 0; i < colors.size(); ++i) {
                    tooltip.add((Component)DyeableItem.getColorName(colors.m_128763_(i)).m_6881_().m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }
}

