/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.research.group.ResearchGroup;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import xyz.iwolfking.sophisticatedvault.blocks.SophisticatedVaultChestBase;
import xyz.iwolfking.sophisticatedvault.blocks.tiles.SophisticatedVaultChestEntity;
import xyz.iwolfking.sophisticatedvault.config.SophisticatedVaultConfig;
import xyz.iwolfking.sophisticatedvault.init.ModAddons;
import xyz.iwolfking.sophisticatedvault.integration.VHAPIIntegration;
import xyz.iwolfking.vhapi.api.events.VaultConfigEvent;

@Mod(value="sophisticatedvault")
public class SophisticatedVault {
    public static final String MODID = "sophisticatedvault";

    public SophisticatedVault() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SophisticatedVaultConfig.COMMON_SPEC, "sophisticated-vault-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SophisticatedVaultConfig.SERVER_SPEC, "sophisticated-vault-server.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModAddons::onAddPackFinders);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(this::onBlockBreak);
        eventBus.addListener(this::onVaultConfigsLoad);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        VHAPIIntegration.initiateConfigs();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    private void onVaultConfigsLoad(VaultConfigEvent.End event) {
        if (event.getType() == VaultConfigEvent.Type.NORMAL && ((Boolean)SophisticatedVaultConfig.COMMON.enableSophisticatedStorageResearch.get()).booleanValue()) {
            ResearchGroup storageGroup = (ResearchGroup)ModConfigs.RESEARCH_GROUPS.getGroups().get("Storage");
            storageGroup.getResearch().add("Sophisticated Storage");
        }
    }

    private void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (event.getState().m_60734_() instanceof SophisticatedVaultChestBase && !player.m_6144_()) {
            Level level = player.m_183503_();
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)event.getPos(), SophisticatedVaultChestEntity.class).ifPresent(wbe -> {
                if (!wbe.isPacked()) {
                    AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
                    InventoryHelper.iterate((IItemHandler)wbe.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                        if (!stack.m_41619_()) {
                            droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.m_41613_() / (double)Math.min(stack.m_41741_(), 20)));
                        }
                    });
                    if (droppedItemEntityCount.get() > (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
                        event.setCanceled(true);
                        ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
                        Component packingTapeItemName = packingTapeItem.m_7626_(new ItemStack((ItemLike)packingTapeItem));
                        if (packingTapeItemName instanceof TranslatableComponent) {
                            TranslatableComponent c = (TranslatableComponent)packingTapeItemName;
                            c.m_130940_(ChatFormatting.GREEN);
                        }
                        player.m_6352_(StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{event.getState().m_60734_().m_49954_().m_130940_(ChatFormatting.GREEN), new TextComponent(String.valueOf(droppedItemEntityCount.get())).m_130940_(ChatFormatting.RED), packingTapeItemName}), Util.f_137441_);
                    }
                }
            });
        }
    }

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MODID, id);
    }
}

