/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault.blocks;

import com.google.common.base.Supplier;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import xyz.iwolfking.sophisticatedvault.blocks.tiles.SophisticatedVaultChestEntity;
import xyz.iwolfking.sophisticatedvault.init.ModBlocks;
import xyz.iwolfking.sophisticatedvault.items.SophisticatedVaultStorageBlockItem;

public class SophisticatedVaultChestBase
extends StorageBlockBase
implements SimpleWaterloggedBlock,
IAdditionalDropDataBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public SophisticatedVaultChestBase(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, 2.5f);
    }

    public SophisticatedVaultChestBase(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.5f, explosionResistance).m_60918_(SoundType.f_56736_), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED))) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? SophisticatedVaultChestBase.createTickerHelper(blockEntityType, ModBlocks.SOPHISTICATED_VAULT_CHEST_ENTITY_BLOCK_ENTITY_TYPE, (l, p, s, be) -> SophisticatedVaultChestEntity.lidAnimateTick(be)) : super.m_142354_(level, state, blockEntityType);
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, SophisticatedVaultChestEntity.class).map(b -> {
            ItemStack stackInHand = player.m_21120_(hand);
            if (b.isPacked()) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_ || hand == InteractionHand.OFF_HAND) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryItemInteraction(player, hand, (SophisticatedVaultChestEntity)((Object)b), stackInHand, (Direction)state.m_61143_((Property)FACING), hitResult)) {
                return InteractionResult.SUCCESS;
            }
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(StorageBlockEntity::m_5446_).orElse(TextComponent.f_131282_)), (BlockPos)pos);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }).orElse(InteractionResult.PASS);
    }

    @Nullable
    public SophisticatedVaultChestEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SophisticatedVaultChestEntity(pos, state);
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, TICKING});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, SophisticatedVaultChestEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.SOPHISTICATED_VAULT_CHEST_ENTITY_BLOCK_ENTITY_TYPE;
    }

    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    protected boolean tryItemInteraction(Player player, InteractionHand hand, SophisticatedVaultChestEntity b, ItemStack stackInHand, Direction facing, BlockHitResult hitResult) {
        if (stackInHand.m_41720_() == ModItems.PACKING_TAPE.get()) {
            if (!player.m_7500_() && stackInHand.m_41773_() >= stackInHand.m_41776_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            b.setPacked(true);
            b.removeFromController();
            WorldHelper.notifyBlockUpdate((BlockEntity)b);
            return true;
        }
        return false;
    }

    public void addDropData(ItemStack itemStack, StorageBlockEntity storageBlockEntity) {
        SophisticatedVaultChestEntity wbe;
        if (storageBlockEntity instanceof SophisticatedVaultChestEntity && (wbe = (SophisticatedVaultChestEntity)storageBlockEntity).isPacked()) {
            StorageWrapper storageWrapper = storageBlockEntity.getStorageWrapper();
            UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
            CompoundTag storageContents = wbe.getStorageContentsTag();
            if (!storageContents.m_128456_()) {
                ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                NBTHelper.setUniqueId((ItemStack)itemStack, (String)"uuid", (UUID)storageUuid);
            }
            SophisticatedVaultStorageBlockItem.setPacked(itemStack, true);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, SophisticatedVaultChestEntity.class).ifPresent(be -> {
            NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").ifPresent(uuid -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                be.m_142466_(itemContentsStorage.getOrCreateStorageContents(uuid));
                itemContentsStorage.removeStorageContents(uuid);
            });
            if (stack.m_41788_()) {
                be.setCustomName(stack.m_41786_());
            }
            Objects.requireNonNull(be);
            StorageWrapper var10001 = be.getStorageWrapper();
            Objects.requireNonNull(var10001);
            var10001 = be.getStorageWrapper();
            Objects.requireNonNull(var10001);
            be.tryToAddToController();
            if (placer != null && placer.m_21206_().m_41720_() == ModItems.STORAGE_TOOL.get()) {
                StorageToolItem.useOffHandOnPlaced((ItemStack)placer.m_21206_(), (StorageBlockEntity)be);
            }
        });
    }
}

