/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault.blocks.tiles;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import xyz.iwolfking.sophisticatedvault.init.ModBlocks;
import xyz.iwolfking.sophisticatedvault.items.SophisticatedVaultStorageBlockItem;

public class SophisticatedVaultChestEntity
extends StorageBlockEntity
implements IAdditionalDropDataBlock {
    private boolean packed = false;
    private static final String PACKED_TAG = "packed";
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            SophisticatedVaultChestEntity.this.playSound(state, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            SophisticatedVaultChestEntity.this.playSound(state, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int previousOpenCount, int openCount) {
            SophisticatedVaultChestEntity.this.chestLidController.m_155377_(openCount > 0);
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu var3 = player.f_36096_;
            if (var3 instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)var3;
                return storageContainerMenu.getStorageBlockEntity() == SophisticatedVaultChestEntity.this;
            }
            return false;
        }
    };

    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        tag.m_128379_(PACKED_TAG, this.packed);
    }

    public CompoundTag getStorageContentsTag() {
        CompoundTag contents = this.m_187482_();
        contents.m_128379_(PACKED_TAG, false);
        return contents;
    }

    public void loadSynchronizedData(CompoundTag tag) {
        super.loadSynchronizedData(tag);
        this.packed = tag.m_128471_(PACKED_TAG);
    }

    protected ContainerOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    protected String getStorageType() {
        return "chest";
    }

    public SophisticatedVaultChestEntity(BlockPos pos, BlockState state) {
        super(pos, state, ModBlocks.SOPHISTICATED_VAULT_CHEST_ENTITY_BLOCK_ENTITY_TYPE);
    }

    public static void lidAnimateTick(SophisticatedVaultChestEntity chestBlockEntity) {
        if (chestBlockEntity.m_58900_().m_60734_().equals((Object)ModBlocks.SOPHISTICATED_VAULT_GILDED_STRONGBOX) || chestBlockEntity.m_58900_().m_60734_().equals((Object)ModBlocks.SOPHISTICATED_VAULT_ORNATE_STRONGBOX) || chestBlockEntity.m_58900_().m_60734_().equals((Object)ModBlocks.SOPHISTICATED_VAULT_LIVING_STRONGBOX) || chestBlockEntity.m_58900_().m_60734_().equals((Object)ModBlocks.SOPHISTICATED_VAULT_UNIQUE_CRATE)) {
            return;
        }
        chestBlockEntity.chestLidController.m_155374_();
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    void playSound(BlockState state, SoundEvent sound) {
        Block var4;
        if (this.f_58857_ != null && (var4 = state.m_60734_()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)var4;
            Vec3i vec3i = storageBlock.getFacing(state).m_122436_();
            double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
            double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
            double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
            this.f_58857_.m_6263_((Player)null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
            return;
        }
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
    }

    public boolean shouldDropContents() {
        return !this.isPacked();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return this.isPacked() && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.empty() : super.getCapability(cap, side);
    }

    public boolean canConnectStorages() {
        return !this.packed && super.canConnectStorages();
    }

    public boolean canBeConnected() {
        return !this.packed && super.canBeConnected();
    }

    public boolean canBeLinked() {
        return !this.packed;
    }

    public void addDropData(ItemStack itemStack, StorageBlockEntity storageBlockEntity) {
        SophisticatedVaultChestEntity wbe;
        if (storageBlockEntity instanceof SophisticatedVaultChestEntity && (wbe = (SophisticatedVaultChestEntity)storageBlockEntity).isPacked()) {
            StorageWrapper storageWrapper = storageBlockEntity.getStorageWrapper();
            UUID storageUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
            CompoundTag storageContents = wbe.getStorageContentsTag();
            if (!storageContents.m_128456_()) {
                ItemContentsStorage.get().setStorageContents(storageUuid, storageContents);
                NBTHelper.setUniqueId((ItemStack)itemStack, (String)"uuid", (UUID)storageUuid);
            }
            SophisticatedVaultStorageBlockItem.setPacked(itemStack, true);
        }
    }
}

