/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.block.model.VaultChestModel;
import iskallia.vault.block.render.VaultChestRenderer;
import iskallia.vault.init.ModBlocks;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import xyz.iwolfking.sophisticatedvault.blocks.tiles.SophisticatedVaultChestEntity;
import xyz.iwolfking.sophisticatedvault.mixins.VaultChestRendererAccessor;

public class SophisticatedVaultChestRenderer
implements BlockEntityRenderer<SophisticatedVaultChestEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final ModelPart lidPart;
    private final ModelPart bottomPart;
    private final ModelPart lockPart;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, new Vec3(-0.0625, 0.0, -0.0075));

    public SophisticatedVaultChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ClientEventHandler.CHEST_LAYER);
        this.bottomPart = modelpart.m_171324_(BOTTOM);
        this.lidPart = modelpart.m_171324_(LID);
        this.lockPart = modelpart.m_171324_(LOCK);
    }

    public void render(SophisticatedVaultChestEntity sophisticatedVaultChestEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        Block block = this.convertSophisticatedToVaultBlock(this.convertSophisticatedToVaultBlock(sophisticatedVaultChestEntity.m_58900_().m_60734_()));
        VaultChestModel model = (VaultChestModel)VaultChestRendererAccessor.getMapOfModels().get(block);
        if (model != null) {
            this.customRender(model, sophisticatedVaultChestEntity, v, poseStack, multiBufferSource, i, i1);
        } else {
            this.renderFallbackBlockModel(sophisticatedVaultChestEntity, poseStack, multiBufferSource, i, i1);
        }
    }

    private void renderFallbackBlockModel(SophisticatedVaultChestEntity chestEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Minecraft mc = Minecraft.m_91087_();
        BlockState fallbackState = chestEntity.m_58900_();
        BakedModel bakedModel = mc.m_91289_().m_110910_(fallbackState);
        poseStack.m_85836_();
        mc.m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), bufferSource.m_6299_(RenderType.m_110463_()), fallbackState, bakedModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        if (this.shouldRenderDisplayItem(chestEntity.m_58899_())) {
            LockRenderer.renderLock((StorageBlockEntity)chestEntity, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)packedOverlay, (float)0.5125f, () -> false);
            this.displayItemRenderer.renderDisplayItem((StorageBlockEntity)chestEntity, poseStack, bufferSource, packedLight, packedOverlay);
        }
        poseStack.m_85849_();
    }

    public void customRender(VaultChestModel model, SophisticatedVaultChestEntity chestEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockstate = chestEntity.m_58900_();
        StorageTextureManager matManager = StorageTextureManager.INSTANCE;
        Map chestMaterials = matManager.getWoodChestMaterials(WoodType.f_61833_);
        poseStack.m_85836_();
        Direction facing = (Direction)blockstate.m_61143_((Property)ChestBlock.f_51478_);
        float f = facing.m_122435_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        StorageWrapper storageWrapper = chestEntity.getStorageWrapper();
        Material tierMaterial = this.getTierMaterial(blockstate.m_60734_());
        VertexConsumer vertexconsumer = tierMaterial.m_119194_(bufferSource, RenderType::m_110452_);
        model.setLidAngle(lidAngle);
        model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (chestEntity.isPacked()) {
            VertexConsumer consumer = ((Material)chestMaterials.get(StorageTextureManager.ChestMaterial.PACKED)).m_119194_(bufferSource, RenderType::m_110452_);
            poseStack.m_85836_();
            poseStack.m_85837_(-0.005, -0.005, -0.005);
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            this.renderBottomAndLid(poseStack, consumer, lidAngle, packedLight, packedOverlay);
            poseStack.m_85849_();
        } else if (this.shouldRenderDisplayItem(chestEntity.m_58899_())) {
            LockRenderer.renderLock((StorageBlockEntity)chestEntity, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)packedOverlay, (float)0.5125f, () -> false);
            this.displayItemRenderer.renderDisplayItem((StorageBlockEntity)chestEntity, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private boolean shouldRenderDisplayItem(BlockPos chestPos) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        return Vec3.m_82512_((Vec3i)chestPos).m_82509_((Position)camera.m_90583_(), 32.0);
    }

    private void renderBottomAndLid(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        this.bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private void renderBottomAndLidWithTint(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay, int tint) {
        float tintRed = (float)(tint >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(tint >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(tint & 0xFF) / 255.0f;
        this.lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lidPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
        this.bottomPart.m_104306_(poseStack, consumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }

    private void renderLock(PoseStack poseStack, VertexConsumer consumer, float lidAngle, int packedLight, int packedOverlay) {
        this.lockPart.f_104203_ = -(lidAngle * 1.5707964f);
        this.lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private Block convertSophisticatedToVaultBlock(Block block) {
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_TREASURE_CHEST)) {
            return ModBlocks.TREASURE_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_WOODEN_CHEST)) {
            return ModBlocks.WOODEN_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_GILDED_CHEST)) {
            return ModBlocks.GILDED_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ORNATE_CHEST)) {
            return ModBlocks.ORNATE_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_LIVING_CHEST)) {
            return ModBlocks.LIVING_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ALTAR_CHEST)) {
            return ModBlocks.ALTAR_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_FLESH_CHEST)) {
            return ModBlocks.FLESH_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ENIGMA_CHEST)) {
            return ModBlocks.ENIGMA_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_HARDENED_CHEST)) {
            return ModBlocks.HARDENED_CHEST;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ORNATE_STRONGBOX)) {
            return ModBlocks.ORNATE_STRONGBOX;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_GILDED_STRONGBOX)) {
            return ModBlocks.GILDED_STRONGBOX;
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_LIVING_STRONGBOX)) {
            return ModBlocks.LIVING_STRONGBOX;
        }
        return block;
    }

    private Material getTierMaterial(Block block) {
        if (block == xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_TREASURE_CHEST) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.TREASURE_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_WOODEN_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.WOODEN_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_GILDED_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.GILDED_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ORNATE_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.ORNATE_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_LIVING_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.LIVING_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ALTAR_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.ALTAR_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_FLESH_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.FLESH_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ENIGMA_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.ENIGMA_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_HARDENED_CHEST)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.HARDENED_CHEST);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_LIVING_STRONGBOX)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.LIVING_STRONGBOX);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_ORNATE_STRONGBOX)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.ORNATE_STRONGBOX);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_GILDED_STRONGBOX)) {
            return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.GILDED_STRONGBOX);
        }
        if (block.equals((Object)xyz.iwolfking.sophisticatedvault.init.ModBlocks.SOPHISTICATED_VAULT_UNIQUE_CRATE)) {
            return null;
        }
        return (Material)VaultChestRenderer.NORMAL_MATERIAL_MAP.get(ModBlocks.TREASURE_CHEST);
    }
}

