/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SophisticatedVaultConfig {
    public static final Common COMMON;
    public static final Server SERVER;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        COMMON = (Common)commonSpecPair.getLeft();
        SERVER = (Server)serverSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableSophisticatedStorageResearch;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("General Settings");
            this.enableSophisticatedStorageResearch = builder.comment("Whether Sophisticated Storage should be research locked").define("enableSophisticatedStorageResearch", true);
            builder.pop();
        }
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableVaultifiedSophisticatedStorage;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("General Settings");
            this.enableVaultifiedSophisticatedStorage = builder.comment("Whether Sophisticated Storage recipes should be vaultified.").define("enableVaultifiedSophisticatedStorage", true);
            builder.pop();
        }
    }
}

