/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault.items;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import xyz.iwolfking.sophisticatedvault.lib.StackStorageWrapper;

public class SophisticatedVaultStorageBlockItem
extends ChestBlockItem {
    public static final String PACKED_TAG = "packed";

    public SophisticatedVaultStorageBlockItem(Block block) {
        super(block);
    }

    public static void setPacked(ItemStack storageStack, boolean packed) {
        storageStack.m_41784_().m_128379_(PACKED_TAG, packed);
    }

    public static boolean isPacked(ItemStack storageStack) {
        return NBTHelper.getBoolean((ItemStack)storageStack, (String)PACKED_TAG).orElse(false);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (!SophisticatedVaultStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        AtomicReference<Object> ret = new AtomicReference<Object>(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (Screen.m_96638_() || mc.f_91074_ != null && !mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                ret.set(new StorageContentsTooltip(stack));
            }
        });
        return Optional.ofNullable(ret.get());
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private IStorageWrapper wrapper = null;

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (stack.m_41613_() == 1 && cap == CapabilityStorageWrapper.getCapabilityInstance()) {
                    this.initWrapper();
                    return LazyOptional.of(() -> this.wrapper).cast();
                }
                return LazyOptional.empty();
            }

            private void initWrapper() {
                if (this.wrapper == null) {
                    UUID uuid = NBTHelper.getUniqueId((ItemStack)stack, (String)"uuid").orElse(null);
                    StackStorageWrapper storageWrapper = new StackStorageWrapper(stack){

                        public String getStorageType() {
                            return "wood_storage";
                        }

                        public Component getDisplayName() {
                            return TextComponent.f_131282_;
                        }

                        protected boolean isAllowedInStorage(ItemStack stackx) {
                            return false;
                        }
                    };
                    if (uuid != null) {
                        CompoundTag compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).m_128469_("storageWrapper");
                        storageWrapper.load(compoundtag);
                        storageWrapper.setContentsUuid(uuid);
                    }
                    this.wrapper = storageWrapper;
                }
            }
        };
    }

    public Component m_7626_(ItemStack stack) {
        return SophisticatedVaultStorageBlockItem.getDisplayName(this.m_5524_());
    }

    public static Component getDisplayName(String descriptionId) {
        return new TranslatableComponent(descriptionId, new Object[]{"", ""});
    }
}

