/*
 * Decompiled with CFR 0.152.
 */
package xyz.iwolfking.sophisticatedvault.lib;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;

public abstract class StackStorageWrapper
extends StorageWrapper {
    private static final String CONTENTS_TAG = "contents";
    private final ItemStack storageStack;

    public StackStorageWrapper(ItemStack storageStack) {
        super(() -> () -> {}, () -> {}, () -> {});
        this.storageStack = storageStack;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable(this.contentsUuid);
    }

    public void setContentsUuid(@Nullable UUID contentsUuid) {
        super.setContentsUuid(contentsUuid);
        if (contentsUuid != null) {
            NBTHelper.setUniqueId((ItemStack)this.storageStack, (String)"uuid", (UUID)contentsUuid);
            ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
            CompoundTag storageContents = itemContentsStorage.getOrCreateStorageContents(contentsUuid);
            if (!storageContents.m_128441_("storageWrapper")) {
                CompoundTag storageWrapperTag = new CompoundTag();
                storageWrapperTag.m_128365_(CONTENTS_TAG, (Tag)new CompoundTag());
                storageContents.m_128365_("storageWrapper", (Tag)storageWrapperTag);
            }
            this.onContentsNbtUpdated();
        }
    }

    protected CompoundTag getContentsNbt() {
        if (this.contentsUuid == null) {
            this.contentsUuid = this.getNewUuid();
        }
        return ItemContentsStorage.get().getOrCreateStorageContents(this.contentsUuid).m_128469_("storageWrapper").m_128469_(CONTENTS_TAG);
    }

    protected void onUpgradeRefresh() {
    }

    public int getDefaultNumberOfInventorySlots() {
        BlockItemBase blockItem;
        Block var4;
        Item var3 = this.storageStack.m_41720_();
        if (var3 instanceof BlockItemBase && (var4 = (blockItem = (BlockItemBase)var3).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)var4;
            int var10000 = storageBlock.getNumberOfInventorySlots();
            return var10000;
        }
        int var10000 = 0;
        return var10000;
    }

    protected void loadSlotNumbers(CompoundTag tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfInventorySlots").orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((ItemStack)this.storageStack, (String)"numberOfUpgradeSlots").orElse(0);
    }

    public int getDefaultNumberOfUpgradeSlots() {
        BlockItemBase blockItem;
        Block var4;
        Item var3 = this.storageStack.m_41720_();
        if (var3 instanceof BlockItemBase && (var4 = (blockItem = (BlockItemBase)var3).m_40614_()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)var4;
            int var10000 = storageBlock.getNumberOfUpgradeSlots();
            return var10000;
        }
        int var10000 = 0;
        return var10000;
    }
}

