/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.Segment;
import java.io.DataInput;
import java.io.IOException;
import javax.imageio.IIOException;

final class HuffmanTable
extends Segment {
    private final int[][][] l = new int[4][2][16];
    private final int[] th = new int[4];
    final int[][][][] v = new int[4][2][16][200];
    final int[][] tc = new int[4][2];
    static final int MSB = Integer.MIN_VALUE;

    private HuffmanTable() {
        super(65476);
    }

    void buildHuffTables(int[][][] nArray) throws IOException {
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                if (this.tc[j][k] == 0) continue;
                this.buildHuffTable(nArray[j][k], this.l[j][k], this.v[j][k]);
            }
        }
    }

    private void buildHuffTable(int[] nArray, int[] nArray2, int[][] nArray3) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 256;
        int n5 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            for (n2 = 0; n2 < nArray2[n3]; ++n2) {
                for (n = 0; n < n4 >> n3 + 1; ++n) {
                    nArray[n5] = nArray3[n3][n2] | n3 + 1 << 8;
                    ++n5;
                }
            }
        }
        n3 = 1;
        while (n5 < 256) {
            nArray[n5] = n3 | Integer.MIN_VALUE;
            ++n3;
            ++n5;
        }
        n3 = 1;
        n5 = 0;
        for (n2 = 8; n2 < 16; ++n2) {
            for (n = 0; n < nArray2[n2]; ++n) {
                for (int j = 0; j < n4 >> n2 - 7; ++j) {
                    nArray[n3 * 256 + n5] = nArray3[n2][n] | n2 + 1 << 8;
                    ++n5;
                }
                if (n5 < 256) continue;
                if (n5 > 256) {
                    throw new IIOException("JPEG Huffman Table error");
                }
                n5 = 0;
                ++n3;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DHT[");
        for (int j = 0; j < this.tc.length; ++j) {
            for (int k = 0; k < this.tc[j].length; ++k) {
                if (this.tc[j][k] == 0) continue;
                if (stringBuilder.length() > 4) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("id: ");
                stringBuilder.append(j);
                stringBuilder.append(", class: ");
                stringBuilder.append(k);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static Segment read(DataInput dataInput, int n) throws IOException {
        int n2 = 2;
        HuffmanTable huffmanTable = new HuffmanTable();
        while (n2 < n) {
            int n3;
            int n4 = dataInput.readUnsignedByte();
            ++n2;
            int n5 = n4 & 0xF;
            if (n5 > 3) {
                throw new IIOException("Unexpected JPEG Huffman Table Id (> 3):" + n5);
            }
            int n6 = n4 >> 4;
            if (n6 > 2) {
                throw new IIOException("Unexpected JPEG Huffman Table class (> 2): " + n6);
            }
            huffmanTable.th[n5] = 1;
            huffmanTable.tc[n5][n6] = 1;
            for (n3 = 0; n3 < 16; ++n3) {
                huffmanTable.l[n5][n6][n3] = dataInput.readUnsignedByte();
                ++n2;
            }
            for (n3 = 0; n3 < 16; ++n3) {
                for (int j = 0; j < huffmanTable.l[n5][n6][n3]; ++j) {
                    if (n2 > n) {
                        throw new IIOException("JPEG Huffman Table format error");
                    }
                    huffmanTable.v[n5][n6][n3][j] = dataInput.readUnsignedByte();
                    ++n2;
                }
            }
        }
        if (n2 != n) {
            throw new IIOException("JPEG Huffman Table format error, bad segment length: " + n);
        }
        return huffmanTable;
    }
}

