/*
 * Decompiled with CFR 0.152.
 */
package observable.forge;

import com.google.gson.Gson;
import cpw.mods.cl.ModuleClassLoader;
import dev.architectury.platform.forge.EventBuses;
import java.util.Objects;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import observable.Observable;
import observable.forge.ForgeClientHooks;
import observable.server.ModLoader;
import observable.server.Remapper;

@Mod(value="observable")
public class ObservableForge {
    public ObservableForge() {
        String patchLoader = System.getenv("O_PATCH_LOADER");
        if (Objects.equals(patchLoader, "true")) {
            ModuleClassLoader loader = (ModuleClassLoader)this.getClass().getClassLoader();
            loader.setFallbackClassLoader((ClassLoader)new HackyLoader());
        }
        Remapper.modLoader = ModLoader.FORGE;
        EventBuses.registerModEventBus((String)"observable", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientInit);
        Observable.init();
    }

    public void onClientInit(FMLClientSetupEvent ev) {
        Observable.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)ForgeClientHooks.INSTANCE);
    }

    public static class HackyLoader
    extends ClassLoader {
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return ClassLoader.getPlatformClassLoader().loadClass(name);
            }
            catch (Throwable e) {
                try {
                    return Gson.class.getClassLoader().loadClass(name);
                }
                catch (Throwable e2) {
                    return ClassLoader.getSystemClassLoader().loadClass(name);
                }
            }
        }
    }
}

