/*
 * Decompiled with CFR 0.152.
 */
package observable.shadow.imgui.internal.classes;

import glm_.glm;
import glm_.vec2.Vec2;
import glm_.vec2.Vec2i;
import glm_.vec4.Vec4;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import observable.shadow.imgui.internal.Generic_helpersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\bI\u0010\u0014B\u0019\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020J\u0012\u0006\u0010\u001a\u001a\u00020J\u00a2\u0006\u0004\bI\u0010KB\u0019\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020J\u0012\u0006\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\bI\u0010LB\u0019\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0002\u0012\u0006\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\bI\u0010\u001cB\u0019\b\u0016\u0012\u0006\u0010\u0019\u001a\u00020\u0002\u0012\u0006\u0010\u001a\u001a\u00020J\u00a2\u0006\u0004\bI\u0010MB\u0011\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\bI\u0010\u001eB\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\bI\u0010NB)\b\u0016\u0012\u0006\u0010O\u001a\u00020\u0011\u0012\u0006\u0010P\u001a\u00020\u0011\u0012\u0006\u0010Q\u001a\u00020\u0011\u0012\u0006\u0010R\u001a\u00020\u0011\u00a2\u0006\u0004\bI\u0010$J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0006\u00a2\u0006\u0004\b\f\u0010\u000eJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0002H\u0086\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0011H\u0086\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0086\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u001d\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0015H\u0086\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001eJ\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0000H\u0086\u0004\u00a2\u0006\u0004\b\u001b\u0010\bJ-\u0010\u001b\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001b\u0010$J\u000f\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u0015\u00a2\u0006\u0004\b(\u0010)J\u0018\u0010+\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0002H\u0086\u0004\u00a2\u0006\u0004\b+\u0010\u0006J\u0018\u0010-\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0011H\u0086\u0004\u00a2\u0006\u0004\b-\u0010\u0012J\u0018\u0010/\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0011H\u0086\u0004\u00a2\u0006\u0004\b/\u0010\u0012R\u0011\u00102\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00104\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b3\u00101R\u0011\u00106\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b5\u00101R\u0011\u00109\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u0010:\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\"\u0010\u001a\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010<\u001a\u0004\b=\u00101\"\u0004\b>\u0010\u0006R\"\u0010\u0019\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010<\u001a\u0004\b?\u00101\"\u0004\b@\u0010\u0006R\u0011\u0010B\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bA\u00101R\u0011\u0010D\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bC\u00101R\u0011\u0010F\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bE\u00101R\u0011\u0010H\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\bG\u00108\u00a8\u0006S"}, d2={"Lobservable/shadow/imgui/internal/classes/Rect;", "", "Lglm_/vec2/Vec2;", "p", "", "add", "(Lglm_/vec2/Vec2;)V", "r", "(Lobservable/shadow/imgui/internal/classes/Rect;)V", "clipWith", "clipWithFull", "", "contains", "(Lglm_/vec2/Vec2;)Z", "(Lobservable/shadow/imgui/internal/classes/Rect;)Z", "amount", "expand", "", "(F)V", "floor", "()V", "Lglm_/vec4/Vec4;", "v", "overlaps", "(Lglm_/vec4/Vec4;)Z", "min", "max", "put", "(Lglm_/vec2/Vec2;Lglm_/vec2/Vec2;)V", "vec4", "(Lglm_/vec4/Vec4;)V", "rect", "minX", "minY", "maxX", "maxY", "(FFFF)V", "", "toString", "()Ljava/lang/String;", "toVec4", "()Lglm_/vec4/Vec4;", "d", "translate", "dx", "translateX", "dy", "translateY", "getBl", "()Lglm_/vec2/Vec2;", "bl", "getBr", "br", "getCenter", "center", "getHeight", "()F", "height", "isInverted", "()Z", "Lglm_/vec2/Vec2;", "getMax", "setMax", "getMin", "setMin", "getSize", "size", "getTl", "tl", "getTr", "tr", "getWidth", "width", "<init>", "Lglm_/vec2/Vec2i;", "(Lglm_/vec2/Vec2i;Lglm_/vec2/Vec2i;)V", "(Lglm_/vec2/Vec2i;Lglm_/vec2/Vec2;)V", "(Lglm_/vec2/Vec2;Lglm_/vec2/Vec2i;)V", "(Limgui/internal/classes/Rect;)V", "x1", "y1", "x2", "y2", "core"})
public final class Rect {
    @NotNull
    private Vec2 min;
    @NotNull
    private Vec2 max;

    @NotNull
    public final Vec2 getMin() {
        return this.min;
    }

    public final void setMin(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.min = vec2;
    }

    @NotNull
    public final Vec2 getMax() {
        return this.max;
    }

    public final void setMax(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.max = vec2;
    }

    @NotNull
    public final Vec2 getCenter() {
        return this.min.plus(this.max).times(0.5f);
    }

    @NotNull
    public final Vec2 getSize() {
        return this.max.minus(this.min);
    }

    public final float getWidth() {
        return this.max.getX().floatValue() - this.min.getX().floatValue();
    }

    public final float getHeight() {
        return this.max.getY().floatValue() - this.min.getY().floatValue();
    }

    @NotNull
    public final Vec2 getTl() {
        return new Vec2(this.min);
    }

    @NotNull
    public final Vec2 getTr() {
        return new Vec2(this.max.getX().floatValue(), this.min.getY().floatValue());
    }

    @NotNull
    public final Vec2 getBl() {
        return new Vec2(this.min.getX().floatValue(), this.max.getY().floatValue());
    }

    @NotNull
    public final Vec2 getBr() {
        return new Vec2(this.max);
    }

    public final boolean contains(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return p.getX().floatValue() >= this.min.getX().floatValue() && p.getY().floatValue() >= this.min.getY().floatValue() && p.getX().floatValue() < this.max.getX().floatValue() && p.getY().floatValue() < this.max.getY().floatValue();
    }

    public final boolean contains(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.min.getX().floatValue() >= this.min.getX().floatValue() && r.min.getY().floatValue() >= this.min.getY().floatValue() && r.max.getX().floatValue() <= this.max.getX().floatValue() && r.max.getY().floatValue() <= this.max.getY().floatValue();
    }

    public final boolean overlaps(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.min.getY().floatValue() < this.max.getY().floatValue() && r.max.getY().floatValue() > this.min.getY().floatValue() && r.min.getX().floatValue() < this.max.getX().floatValue() && r.max.getX().floatValue() > this.min.getX().floatValue();
    }

    public final boolean overlaps(@NotNull Vec4 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        return v2.getY().floatValue() < this.max.getY().floatValue() && v2.getW().floatValue() > this.min.getY().floatValue() && v2.getX().floatValue() < this.max.getX().floatValue() && v2.getZ().floatValue() > this.min.getX().floatValue();
    }

    public final void add(@NotNull Vec2 p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.min.getX().floatValue() > p.getX().floatValue()) {
            this.min.setX(p.getX().floatValue());
        }
        if (this.min.getY().floatValue() > p.getY().floatValue()) {
            this.min.setY(p.getY().floatValue());
        }
        if (this.max.getX().floatValue() < p.getX().floatValue()) {
            this.max.setX(p.getX().floatValue());
        }
        if (this.max.getY().floatValue() < p.getY().floatValue()) {
            this.max.setY(p.getY().floatValue());
        }
    }

    public final void add(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (this.min.getX().floatValue() > r.min.getX().floatValue()) {
            this.min.setX(r.min.getX().floatValue());
        }
        if (this.min.getY().floatValue() > r.min.getY().floatValue()) {
            this.min.setY(r.min.getY().floatValue());
        }
        if (this.max.getX().floatValue() < r.max.getX().floatValue()) {
            this.max.setX(r.max.getX().floatValue());
        }
        if (this.max.getY().floatValue() < r.max.getY().floatValue()) {
            this.max.setY(r.max.getY().floatValue());
        }
    }

    public final void expand(float amount) {
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() - amount);
        Vec2 vec22 = this.min;
        vec22.setY(vec22.getY().floatValue() - amount);
        Vec2 vec23 = this.max;
        vec23.setX(vec23.getX().floatValue() + amount);
        Vec2 vec24 = this.max;
        vec24.setY(vec24.getY().floatValue() + amount);
    }

    public final void expand(@NotNull Vec2 amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() - amount.getX().floatValue());
        Vec2 vec22 = this.min;
        vec22.setY(vec22.getY().floatValue() - amount.getY().floatValue());
        Vec2 vec23 = this.max;
        vec23.setX(vec23.getX().floatValue() + amount.getX().floatValue());
        Vec2 vec24 = this.max;
        vec24.setY(vec24.getY().floatValue() + amount.getY().floatValue());
    }

    public final void translate(@NotNull Vec2 d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() + d.getX().floatValue());
        Vec2 vec22 = this.min;
        vec22.setY(vec22.getY().floatValue() + d.getY().floatValue());
        Vec2 vec23 = this.max;
        vec23.setX(vec23.getX().floatValue() - d.getX().floatValue());
        Vec2 vec24 = this.max;
        vec24.setY(vec24.getY().floatValue() - d.getY().floatValue());
    }

    public final void translateX(float dx2) {
        Vec2 vec2 = this.min;
        vec2.setX(vec2.getX().floatValue() + dx2);
        Vec2 vec22 = this.max;
        vec22.setX(vec22.getX().floatValue() + dx2);
    }

    public final void translateY(float dy) {
        Vec2 vec2 = this.min;
        vec2.setY(vec2.getY().floatValue() + dy);
        Vec2 vec22 = this.max;
        vec22.setY(vec22.getY().floatValue() + dy);
    }

    public final void clipWith(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.min = this.min.max(r.min);
        this.max = this.max.min(r.max);
    }

    public final void clipWithFull(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.min = glm.INSTANCE.clamp(this.min, r.min, r.max);
        this.max = glm.INSTANCE.clamp(this.max, r.min, r.max);
    }

    public final void floor() {
        this.min.setX(Generic_helpersKt.floor(this.min.getX().floatValue()));
        this.min.setY(Generic_helpersKt.floor(this.min.getY().floatValue()));
        this.max.setX(Generic_helpersKt.floor(this.max.getX().floatValue()));
        this.max.setY(Generic_helpersKt.floor(this.max.getY().floatValue()));
    }

    public final boolean isInverted() {
        return this.min.getX().floatValue() > this.max.getX().floatValue() || this.min.getY().floatValue() > this.max.getY().floatValue();
    }

    @NotNull
    public final Vec4 toVec4() {
        return new Vec4(this.min, this.max);
    }

    public final void put(@NotNull Vec2 min, @NotNull Vec2 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min.put(min);
        this.max.put(max);
    }

    public final void put(float minX, float minY, float maxX, float maxY) {
        this.min.put(minX, minY);
        this.max.put(maxX, maxY);
    }

    public final void put(@NotNull Vec4 vec42) {
        Intrinsics.checkNotNullParameter((Object)vec42, (String)"vec4");
        this.min.put(vec42.getX().floatValue(), vec42.getY().floatValue());
        this.max.put(vec42.getZ().floatValue(), vec42.getW().floatValue());
    }

    public final void put(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.min.put(rect.min);
        this.max.put(rect.max);
    }

    @NotNull
    public String toString() {
        return "min: " + this.min + ", max: " + this.max;
    }

    public Rect() {
        this.min = new Vec2();
        this.max = new Vec2();
    }

    public Rect(@NotNull Vec2i min, @NotNull Vec2i max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(min);
        this.max.put(max);
    }

    public Rect(@NotNull Vec2i min, @NotNull Vec2 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(min);
        this.max = max;
    }

    public Rect(@NotNull Vec2 min, @NotNull Vec2 max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min = new Vec2(min);
        this.max = new Vec2(max);
    }

    public Rect(@NotNull Vec2 min, @NotNull Vec2i max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min = new Vec2(min);
        this.max = new Vec2(max);
    }

    public Rect(@NotNull Vec4 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(v2.getX().floatValue(), v2.getY().floatValue());
        this.max.put(v2.getZ().floatValue(), v2.getW().floatValue());
    }

    public Rect(@NotNull Rect r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(r.min);
        this.max.put(r.max);
    }

    public Rect(float x1, float y1, float x2, float y2) {
        this.min = new Vec2();
        this.max = new Vec2();
        this.min.put(x1, y1);
        this.max.put(x2, y2);
    }
}

